//************************************************************************* //
// Kill Game
// Author: Szirmay-Kalos Laszlo, 2001. November.
//************************************************************************* //
#include "GameEngine.h"

Member * Member :: root = NULL;
 
//--------------------------------------------
ostream& operator<<( ostream& s, Vector& v ) {
//--------------------------------------------
	s << v.X() << ", " << v.Y() << ", " << v.Z();
	return s;
}

//--------------------------------------------
Texture :: Texture( char * filename ) {
//--------------------------------------------
	glEnable(GL_TEXTURE_2D);
	glGenTextures(1, &texture_id);
	glBindTexture(GL_TEXTURE_2D, texture_id);

		// kep betoltese
	int width, height;
	ImageFile image( filename, width, height );

		// set up the texture
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexImage2D(GL_TEXTURE_2D, 0, 3, width, height, 0, GL_RGB, GL_UNSIGNED_BYTE, image.Load() );
	glDisable(GL_TEXTURE_2D);
}


//--------------------------------------------
void BillBoard :: DrawIt() {
//--------------------------------------------
	float viewMatrix[16];
	glGetFloatv(GL_MODELVIEW_MATRIX, viewMatrix);

	float tmp;
	tmp = viewMatrix[1]; viewMatrix[1] = viewMatrix[4]; viewMatrix[4] = tmp;
	tmp = viewMatrix[2]; viewMatrix[2] = viewMatrix[8]; viewMatrix[8] = tmp;
	tmp = viewMatrix[6]; viewMatrix[6] = viewMatrix[9]; viewMatrix[9] = tmp;
    viewMatrix[12] = position.X();
	viewMatrix[13] = position.Y();
	viewMatrix[14] = position.Z();

	glMultMatrixf( viewMatrix );
//	Vector right(viewMatrix[0], viewMatrix[4], viewMatrix[8]);
//	Vector up(viewMatrix[1], viewMatrix[5], viewMatrix[9]);

	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_DST_ALPHA);
	glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_REPLACE);

	glBegin(GL_QUADS);
//	glColor4fv( color.GetArray() );
	glTexCoord2f(0, 0); glVertex2f(-size, -size);
	glTexCoord2f(1, 0); glVertex2f(size, -size);
	glTexCoord2f(1, 1); glVertex2f(size, size);
	glTexCoord2f(0, 1); glVertex2f(-size, size);
//	glTexCoord2f(0.0, 0.0); glVertex3fv((position - (right + up) * size).GetArray() );
//	glTexCoord2f(1.0, 0.0); glVertex3fv((position + (right - up) * size).GetArray() );
//	glTexCoord2f(1.0, 1.0); glVertex3fv((position + (right + up) * size).GetArray() );
//	glTexCoord2f(0.0, 1.0); glVertex3fv((position + (up - right) * size).GetArray() );
	glEnd();

	glDisable(GL_BLEND);
}

//--------------------------------------------
void  ParticleSystem :: DrawIt() {
//--------------------------------------------
	float viewMatrix[16];
	glGetFloatv(GL_MODELVIEW_MATRIX, viewMatrix);

	Vector right(viewMatrix[0], viewMatrix[4], viewMatrix[8]);
	Vector up(viewMatrix[1], viewMatrix[5], viewMatrix[9]);

	glDisable(GL_DEPTH_TEST);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_DST_ALPHA);
	glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);

	glBegin(GL_QUADS);
	if ( particles ) particles -> Draw( right, up );
	glEnd();

	glDisable(GL_BLEND);
	glEnable(GL_DEPTH_TEST);

}
