/********************************************************************
*                      BMP, TARGA FORMATUMU FAJLOK 
*
* - BMP es TARGA fajlok elolvasasa 
*
* Szirmay-Kalos Laszlo (szirmay@iit.bme.hu)
* BME, Iranyitastechnika s Informatika Tanszek
* 2001. december
*********************************************************************/
#include "ImageFile.h"

//-----------------------------------------------------------------------
ImageFile :: ImageFile( char * inputfilename, int& width, int& height ) {
//-----------------------------------------------------------------------
	file = NULL;
	image = imageWithAlpha = NULL;

	file = fopen(inputfilename, "rb");
    if ( !file ) return;

	// Probaljuk a BITMAP formatumot
	BITMAPFILEHEADER  bitmapFileHeader;   // bitmap file header
	fread(&bitmapFileHeader, sizeof(BITMAPFILEHEADER), 1, file);
	if (bitmapFileHeader.bfType == 0x4D42 ) {   // the universal bitmap ID
		// fej beolvasasa es a meretek beallitasa
		BITMAPINFOHEADER bitmapInfoHeader;

		fread(&bitmapInfoHeader, sizeof(BITMAPINFOHEADER), 1, file);
		width = bitmapInfoHeader.biWidth;
		height = bitmapInfoHeader.biHeight;
		size = bitmapInfoHeader.biSizeImage;

		fseek(file, bitmapFileHeader.bfOffBits, SEEK_SET);
		return;
	} else 	fseek(file, 0, SEEK_SET);


	// Probaljuk a TGA formatumot
		
		// fej beolvasasa es a meretek beallitasa
    for(int i = 0;i < 12; i++) fgetc(file);
    width = fgetc(file) + fgetc(file) * 256L;
    height = fgetc(file) + fgetc(file) * 256L;
	size = width * height;
    fgetc(file); fgetc(file);
}

//-----------------------------------------------------------------------
Byte * ImageFile :: Load( ) {
//-----------------------------------------------------------------------
	image = new unsigned char[ size ];

	// read in the bitmap image data
	fread(image, 1, size, file);

	// swap the R and B values to get RGB since the bitmap color format is in BGR
	for (int imageIdx = 0; imageIdx < size; imageIdx += 3) {
		Byte tempRGB = image[imageIdx];
		image[imageIdx] = image[imageIdx + 2];
		image[imageIdx + 2] = tempRGB;
	}
	return image;
} 

//-----------------------------------------------------------------------
Byte * ImageFile :: LoadWithAlpha( ) {
//-----------------------------------------------------------------------
	Load( );
	if ( image == NULL ) return NULL;

	Byte * imageWithAlpha = new unsigned char[ size * 4 / 3 ];

	for (int src = 0, dst = 0; src < size; src +=3, dst +=4) {
		// if the pixel is black, set the alpha to 0. Otherwise, set it to 255.
		if (image[src] == 0 && image[src+1] == 0 && image[src+2] == 0) 
				image[dst+3] = 0;
		else	image[dst+3] = 0xFF;

		// copy pixel data over
		imageWithAlpha[dst]   = image[src];
		imageWithAlpha[dst+1] = image[src+1];
		imageWithAlpha[dst+2] = image[src+2];
	}
	return imageWithAlpha;
}

