#ifndef COLOR_H
#define COLOR_H

#pragma pack(16)

#define SIMD

//--------------------------------------------
class Color {
//--------------------------------------------
	float R, G, B, A;
 public:
	Color( ) { }
	Color( float R0, float G0, float B0, float A0 = 1.0 ) { R = R0; G = G0; B = B0; A = A0; }
	
	Color operator*( const Color& c ) { 
		__declspec(align(16)) Color result;
#ifdef SIMD
		__asm {
			mov		esi, this
			mov		edi, c
			movups	xmm0, [esi]
			movups	xmm1, [edi]
			mulps	xmm0, xmm1
			movaps	result, xmm0
		}
#else
		result.R = R * v.R; result.G = G * v.G; result.B = B * v.B; result.A = A * v.A; 
#endif
		return result;
	}

	Color operator+( const Color& c ) { 
		__declspec(align(16)) Color result;

#ifdef SIMD
		__asm {
			mov		esi, this
			mov		edi, c
			movups	xmm0, [esi]
			movups	xmm1, [edi]
			addps	xmm0, xmm1
			movaps	result, xmm0
		}
#else
		result.R = R + v.R; result.G = G + v.G; result.B = B + v.B; result.A = A + v.A; 
#endif
		return result;
	}

	Color operator*( float f ) { 
		__declspec(align(16)) Color result( R * f, G * f, B * f, A * f ); 
		return result;
	}

	void operator+=( const Color& c ) { 
#ifdef SIMD
		__asm {
			mov		esi, this
			mov		edi, c
			movups	xmm0, [esi]
			movups	xmm1, [edi]
			addps	xmm0, xmm1
			movups	[esi], xmm0
		}
#else
		R += c.R; G += c.G; B += c.B; A += c.A; 
#endif
	}

	void operator*=( float f ) { R *= f; G *= f; B *= f; A *= f; }

	Color operator-( const Color& c ) { 
		__declspec(align(16)) Color result;  
#ifdef SIMD
		__asm {
			mov		esi, this
			mov		edi, c
			movups	xmm0, [esi]
			movups	xmm1, [edi]
			subps	xmm0, xmm1
			movaps	result, xmm0
		}
#else
		result.R = R - v.R; result.G = G - v.G; result.B = B - v.B; result.A = A - v.A;
#endif
		return result;
	}

	Color operator/( float f ) { 
		__declspec(align(16)) Color result( R/f, G/f, B/f, A/f ); 
		return result;
	}
	float * GetArray() { return &R; }
	float Red() { return R; }
	float Green() { return G; }
	float Blue() { return B; }
};

#endif