//************************************************************************* //
// GLUT Window class
// Author: Szirmay-Kalos Laszlo, 2001. November.
//************************************************************************* //
#include <windows.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glut.h>
#include <process.h>

#define WIDTH  400
#define HEIGHT 400

//--------------------------------------------
class Timer {
//--------------------------------------------
    long time, start_time;
    long GetTimeInMsec( ) { return glutGet( GLUT_ELAPSED_TIME ); }
public:
    Timer( ) { start_time = time = GetTimeInMsec( ); }
    float GetTime( ) {
	   return (GetTimeInMsec() - start_time) / 1000.0f;
    }
    float GetElapsedTime( ) { 
        long old_time = time;
        time = GetTimeInMsec( );
        return (float)(time - old_time) / 1000.0f;
    }
};

//--------------------------------------------
class GLUTWindow {
//--------------------------------------------
	static GLUTWindow  * pwindow;

	Timer	timer;

	BOOL	key_status[256];
	BOOL	mouseMove; 
	int		mouseX, mouseY;

public:
	static void DisplayFunc( ) { pwindow -> Render( ); }
	static void IdleFunc( ) { pwindow -> Do_a_Step( pwindow -> timer.GetElapsedTime() ); }
	static void MouseMotionFunc( int x, int y ) { pwindow -> MouseMotion( x, y ); } 
	static void KeyboardFunc( unsigned char key, int x, int y ) { pwindow -> Keyboard( (int)key ); } 
	static void SpecialKeyboardFunc( int key, int x, int y ) { pwindow -> Keyboard( key ); } 

	GLUTWindow( );

	void Keyboard( int key ) { 
		key_status[ key ] = TRUE; 
	}

	BOOL GetKeyStatus( int key ) {
		BOOL press = key_status[ key ];
		key_status[ key ] = FALSE;
		return press;
	}
	BOOL IsUp()	   { return GetKeyStatus( GLUT_KEY_UP ); }
	BOOL IsDown()  { return GetKeyStatus( GLUT_KEY_DOWN ); }
	BOOL IsLeft()  { return GetKeyStatus( GLUT_KEY_LEFT ); }
	BOOL IsRight() { return GetKeyStatus( GLUT_KEY_RIGHT ); }
	
	void MouseMotion( int x, int y ) {
		mouseMove = TRUE;
		mouseX = x; mouseY = y;
	}

	BOOL IsMouseMoved( ) { 
		BOOL move = mouseMove;
		mouseMove = FALSE;
		return move;
	}

	float MouseX() { return mouseX; }
	float MouseY() { return mouseY; }

	virtual void Render( ) { }
	virtual void Do_a_Step( float time ) { }
	void SwapBuffers( ) { glutSwapBuffers( ); }
	void SaveImage( );
};



//--------------------------------------------
class Application {
//--------------------------------------------
public:
	void Start( );
	void Stop( ) { exit( -1 ); }
};