/*
 * Created by SharpDevelop.
 * User: phil
 * Date: 2010.03.30.
 * Time: 15:57
 * 
 * To change this template use Tools | Options | Coding | Edit Standard Headers.
 */
using System;

namespace Noise.Controls
{
	/// <summary>
	/// Description of Axis.
	/// </summary>
	public class Axis
	{
		protected double minimum;
		protected double maximum;
		protected AxisType type;
		protected AxisTitle title = new AxisTitle();
		protected bool gridVisible = true;
		protected bool autoscaled = true;
		
		public Axis(double minimum, double maximum, AxisType type)
		{
			this.minimum = minimum;
			this.maximum = maximum;
			this.type = type;
		}
		
		public Axis(AxisType type) : this(0.0, 0.0, type) { }
		
		
		public bool Autoscaled {
			get { return autoscaled; }
			set { autoscaled = value; }
		}
		
		public bool GridVisible {
			get { return gridVisible; }
			set { gridVisible = value; }
		}
		
		public double Minimum {
			get { return minimum; }
			set { minimum = value; }
		}
		
		public double Maximum {
			get { return maximum; }
			set { maximum = value; }
		}
		
		public AxisTitle Title {
			get { return title; }
		}
		
	}
}
