/*
 * Created by SharpDevelop.
 * User: phil
 * Date: 2010.04.14.
 * Time: 10:37
 * 
 * To change this template use Tools | Options | Coding | Edit Standard Headers.
 */
using System;
using System.Drawing;

namespace Noise.Controls
{
	/// <summary>
	/// Description of AxisTitle.
	/// </summary>
	public class AxisTitle
	{
		protected string text;
		protected Font font = new Font("Trebuchet MS", 14.0f);
		protected Brush brush = new SolidBrush(Color.Black);
		protected StringFormat format;
		
		public AxisTitle(string text)
		{
			this.text = text;
			format = new StringFormat();
			format.Alignment = StringAlignment.Center;
			format.LineAlignment = StringAlignment.Center;
		}
		
		public AxisTitle() : this(null) { }
		
		public string Text {
			get { return text; }
			set { text = value; }
		}
		
		public Font Font {
			get { return font; }
			set { font = value; }
		}
		
		public Brush Brush {
			get { return brush; }
			set { brush = value; }
		}
		
		public bool IsEmpty {
			get { return String.IsNullOrEmpty(text); }
		}
		
		internal void Draw(Graphics graphics, float x, float y)
		{
			if (String.IsNullOrEmpty(text)) return;
			
			graphics.DrawString(text, font, brush, x, y, format);
		}
		
		internal void Draw(Graphics graphics, RectangleF layoutRectangle)
		{
			if (String.IsNullOrEmpty(text)) return;
			
			graphics.DrawString(text, font, brush, layoutRectangle, format);
		}
		
		internal SizeF Measure(Graphics graphics)
		{
			return graphics.MeasureString(text, font);
		}
		
	}
}
