/*
 * Created by SharpDevelop.
 * User: phil
 * Date: 2010.03.11.
 * Time: 14:42
 * 
 * To change this template use Tools | Options | Coding | Edit Standard Headers.
 */
using System;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;

namespace Noise.Controls
{
	/// <summary>
	/// Description of ColourPickerControl.
	/// </summary>
	public partial class ColourPickerControl : UserControl
	{
		public event EventHandler ColourChanged;
		
		public ColourPickerControl()
		{
			InitializeComponent();
			panel.Click += HandleClickEvents;
		}
		
		[EditorBrowsable]
		public String Label {
			get { return label.Text; }
			set { label.Text = value; }
		}
		
		[EditorBrowsable]
		public Color Colour {
			get { return panel.BackColor; }
			set { panel.BackColor = value; }
		}
		
		protected void HandleClickEvents(object sender, EventArgs e)
		{
			if (sender == panel) {
				using (ColorDialog colourDialogue = new ColorDialog()) {
					if (colourDialogue.ShowDialog() == DialogResult.OK) {
						Color oldColour = panel.BackColor;
						panel.BackColor = colourDialogue.Color;
						if (panel.BackColor != oldColour) OnColourChanged(new EventArgs());
					}
				}
			}
		}
		
		protected virtual void OnColourChanged(EventArgs e)
		{
			if (ColourChanged != null) {
				ColourChanged(this, e);
			}
		}
		
	}
}
