/*
 * Created by SharpDevelop.
 * User: phil
 * Date: 2010.04.14.
 * Time: 11:18
 * 
 * To change this template use Tools | Options | Coding | Edit Standard Headers.
 */
using System;
using System.Collections.Generic;
using System.Drawing;
//
using TetheredSun.Core;

namespace Noise.Controls
{
	/// <summary>
	/// Description of Curve.
	/// </summary>
	public class Curve
	{
		protected Pen line = new Pen(Color.DarkSeaGreen, 2.0f);
		protected DataPointList points;
		protected string label = null;
		protected bool visible = true;
		protected Symbol symbol = null;
		
		public Curve(int capacity)
		{
			points = new DataPointList(capacity);
		}
		
		public Curve() : this(DataPointList.DefaultCapacity) { }
		
		
		public bool HasLine {
			get { return (line != null) && (line.Width > 0); }
		}
		
		public Pen Line {
			get { return line; }
		}
		
		public DataPointList Points {
			get { return points; }
		}
		
		public string Label {
			get { return label; }
			set { label = value; }
		}
		
		public bool Visible {
			get { return visible; }
			set { visible = value; }
		}
		
		public Symbol Symbol {
			get { return symbol; }
			set { symbol = value; }
		}
		
		
	}
}
