/*
 * Created by SharpDevelop.
 * User: phil
 * Date: 2010.04.14.
 * Time: 13:56
 * 
 * To change this template use Tools | Options | Coding | Edit Standard Headers.
 */
using System;
using System.Collections.Generic;

namespace Noise.Controls
{
	/// <summary>
	/// Description of CurveList.
	/// </summary>
	public class CurveList : List<Curve>
	{
		public CurveList() : base() { }
		
		public bool UpdateBounds(out double xMinimum, out double xMaximum, out double yMinimum, out double yMaximum)
		{
			if (this.Count < 1) 
			{
				xMinimum = Double.NaN;
				xMaximum = Double.NaN;
				yMinimum = Double.NaN;
				yMaximum = Double.NaN;
				return false;
			}
			
			double xMin;
			double xMax;
			double yMin;
			double yMax;
			
			this[0].Points.UpdateBounds(out xMinimum, out xMaximum, out yMinimum, out yMaximum);
			
			for (int i = 1; i < this.Count; i++) {
				if (this[i].Points.UpdateBounds(out xMin, out xMax, out yMin, out yMax)) {
					if (xMin < xMinimum) {
						xMinimum = xMin;
					}
										
					if (xMax > xMaximum) {
						xMaximum = xMax;
					}
					
					if (yMin < yMinimum) {
						yMinimum = yMin;
					}
					
					if (yMax > yMaximum) {
						yMaximum = yMax;
					}
				} else {
					continue;
				}
			}
			
			return true;
		}
	}
}
