﻿/*
 * Készítette a SharpDevelop.
 * Felhasználó: phil
 * Dátum: 2008.08.13.
 * Idő: 10:27
 * Verzió: 0.0.0
 * Legutóbbi változtatás időpontja:
 * Változtatások:
 * Teendők:
 */

using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Drawing.Text;
using System.Threading;
using System.Windows.Forms;
//
using Noise.Controls;
using Noise.DataAcquisition;
using TetheredSun.Core;
using TetheredSun.SignalAnalysis;

namespace Noise.Controls
{

	// TODO: Implement these:
	// 1. CopyToClipBoard should be a background operation.
	// 2. There should be a Trend mode (displaying the periods in the level crossings) in addition to the current mode (call it Continuous?).
	public class DataPlotter : NoiseGraph
	{	
		protected int crossingsCapacity = 32;
		protected volatile int historyLength = 128;
		protected int dueTime = Timeout.Infinite;
		protected int interval = 100;
		protected bool channelsInitialised = false;
		protected bool levelsInitialised = false;
		protected Channel channel;
		protected System.Threading.Timer timer;
		protected volatile bool stopped = true;
		protected volatile bool ready = true;
		protected bool isLevelVisible = true;
		protected Color defaultLineColour = Color.Maroon;
		protected int lineWidth = 1;
		protected Curve data;
		protected Curve level1;
		protected Curve level2;
		protected Curve upCrossings;
		protected Curve downCrossings;
	
		
		public DataPlotter() : base()
		{
			this.timer = new System.Threading.Timer(new TimerCallback(Update), null, Timeout.Infinite, interval);
			//
			this.Curves.Clear();
			this.enforceTickBounds = false;
			//
			data = new Curve(historyLength);
			data.Label = "Data";
			data.Line.Width = lineWidth;
			this.Curves.Add(data);
			//
			level1 = new Curve(historyLength);
			level1.Label = "Level 1";
			level1.Line.Width = lineWidth;
			level1.Line.Color = Color.Orange;
			this.Curves.Add(level1);
			//
			level2 = new Curve(historyLength);
			level2.Label = "Level 2";
			level2.Line.Width = lineWidth;
			level2.Line.Color = Color.Orange;
			this.Curves.Add(level2);
			//
			upCrossings = new Curve(crossingsCapacity);
			upCrossings.Label = "UpCrossings";
			upCrossings.Line.Width = 0.0f;
			upCrossings.Symbol = Symbol.UpTriangle;
			upCrossings.Symbol.Size = 12;
			upCrossings.Symbol.Border.Width = 0.0f;
			upCrossings.Symbol.Border.Color = Color.Firebrick;
			upCrossings.Symbol.Fill = new SolidBrush(Color.Firebrick);
			this.Curves.Add(upCrossings);
			//
			downCrossings = new Curve(crossingsCapacity);
			downCrossings.Label = "DownCrossings";
			downCrossings.Line.Width = 0.0f;
			downCrossings.Symbol = Symbol.DownTriangle;
			downCrossings.Symbol.Size = 12;
			downCrossings.Symbol.Border.Width = 0.0f;
			downCrossings.Symbol.Border.Color = Color.SteelBlue;
			downCrossings.Symbol.Fill = new SolidBrush(Color.SteelBlue);
			this.Curves.Add(downCrossings);
		}
		
		public Channel Channel {
			get { return channel; }
			set { 
				channel = value;
				if (channel != null) LabelYAxis(channel.ChannelInfo);
			}
		}
		
		public Color DefaultLineColour {
			get { return defaultLineColour; }
			set { defaultLineColour = value; }
		}
		
		public int LineWidth {
			get { return lineWidth; }
			set { lineWidth = value; }
		}
				
		public int HistoryLength {
			get { return historyLength; }
			set {
				bool stoppedCopy = stopped;
				if (!stopped) Stop();
				historyLength = value;
				foreach (Curve curve in this.Curves) {
					lock (curve.Points.SyncRoot) {
						curve.Points.Capacity = historyLength;
					}
				}
				if (!stoppedCopy) Start();
			}
		}
		
		public int Interval {
			get { return interval; }
			set {
				interval = value;
				timer.Change(dueTime, this.interval);
			}
		}		
		
		public void CopyToClipBoard()
		{
			string timeLabel = "t [s]";
			string valueLabel;
			string unitLabel;
			string channelString = "Channel ";
			string clipboardString = String.Empty;
			
			if ((channel != null) && (channel.ChannelInfo != null)) {
				if (channel.ChannelInfo.Sensor != null) {
					valueLabel = channel.ChannelInfo.Sensor.GetLabel();
					unitLabel = (String.IsNullOrEmpty(channel.ChannelInfo.Sensor.Unit)) ?
					" [V]" : String.Format(" [{0}]", channel.ChannelInfo.Sensor.Unit);
				} else {
					valueLabel = "U [V]";
					unitLabel = " [V]";
				}
				
				channelString += channel.ChannelInfo.Name;
			} else {
				valueLabel = "U [V]";
				unitLabel = " [V]";
				channelString += "unknown";
			}
			
			clipboardString += channelString + "\t\t\t\t\t\t\t" + Environment.NewLine;
			
			if (data.Points.Count > 0) {
				clipboardString += timeLabel + "\t" + valueLabel + "\t";
				if (level1.Points.Count > 0) {
					clipboardString += "Level 1" + unitLabel + "\t";
				} else {
					clipboardString += "\t";
				}
				if (level2.Points.Count > 0) {
					clipboardString += "Level 2" + unitLabel + "\t";
				} else {
					clipboardString += "\t";
				}
				if (upCrossings.Points.Count > 0) {
					clipboardString += "t up [s]" + "\t" + valueLabel + "\t";
				} else {
					clipboardString += "\t";
				}
				if (downCrossings.Points.Count > 0) {
					clipboardString += "t down [s]" + "\t" + valueLabel + "\t";
				}  else {
					clipboardString += "\t";
				}
				clipboardString = clipboardString.Trim("\t".ToCharArray());
				clipboardString += Environment.NewLine;
			}
			
			for (int i = 0; i < data.Points.Count; i++) {
				clipboardString += data.Points[i].X.ToString() + "\t";
				clipboardString += data.Points[i].Y.ToString() + "\t";
				if (i < level1.Points.Count) {
					clipboardString += level1.Points[i].Y.ToString() + "\t";
				} else {
					clipboardString += "\t";
				}
				if (i < level2.Points.Count) {
					clipboardString += level2.Points[i].Y.ToString() + "\t";
				} else {
					
				}
				if (i < upCrossings.Points.Count) {
					clipboardString += upCrossings.Points[i].X.ToString() + "\t";
					clipboardString += upCrossings.Points[i].Y.ToString() + "\t";
				} else {
					clipboardString += "\t\t";
				}
				if (i < downCrossings.Points.Count) {
					clipboardString += downCrossings.Points[i].X.ToString() + "\t";
					clipboardString += downCrossings.Points[i].Y.ToString() + "\t";
				} else {
					clipboardString += "\t\t";
				}
				clipboardString = clipboardString.Trim("\t".ToCharArray());
				clipboardString += Environment.NewLine;
			}
			Clipboard.SetDataObject(clipboardString);
		}
		

		public void Reset()
		{
			foreach (Curve curve in this.Curves) {
				curve.Points.Clear();
			}
			this.Refresh();
		}
	
		public void Start()
		{
			stopped = false;
			dueTime = 0;
			timer.Change(dueTime, interval);
		}
		
		public void Start(int interval)
		{
			this.interval = interval;
			Start();
		}
		
		public void Stop()
		{
			stopped = true;
			dueTime = Timeout.Infinite;
			timer.Change(dueTime, interval);
		}
		
		
		protected void LabelYAxis(ChannelInfo channelInfo)
		{
			if ((channelInfo.Sensor != null) && (!String.IsNullOrEmpty(channelInfo.Sensor.Quantity))) {
				this.AxisY.Title.Text = channelInfo.Sensor.Quantity;
				if (!String.IsNullOrEmpty(channelInfo.Sensor.Unit)) {
					this.AxisY.Title.Text += String.Format(" [{0}]", channelInfo.Sensor.Unit);
				}
			} else {
				this.AxisY.Title.Text = "U [V]";
			}
		}

		/*protected void Update(object state)
		{
			int itemsInQueue;
			double value;
			double level1Value = (levelCrossingDetector != null) ? levelCrossingDetector.Level - levelCrossingDetector.Hysteresis :
				Double.NaN;
			double level2Value = (levelCrossingDetector != null) ? levelCrossingDetector.Level + levelCrossingDetector.Hysteresis :
				Double.NaN;
			Point<double> upCrossing = null;
			Point<double> downCrossing = null;
			
			lock (channel.SyncRoot) {
				itemsInQueue = channel.Count;
				for (int i = 0; i < itemsInQueue; i++) {
					value = channel.Dequeue();
					if (levelCrossingDetector != null) {
						levelCrossingDetector.Test(time, value);
						upCrossing = levelCrossingDetector.IsUpCrossing ? levelCrossingDetector.CrossingPoint : null;
						downCrossing = levelCrossingDetector.IsDownCrossing ? levelCrossingDetector.CrossingPoint : null;
					} else {
						upCrossing = null;
						downCrossing = null;
					}
					
					lock (data.Points.SyncRoot) { data.Points.Add(time, value); }
					
					if (!Double.IsNaN(level1Value)) {
						lock (level1.Points.SyncRoot) { level1.Points.Add(time, level1Value); }
					}
					
					if (!Double.IsNaN(level2Value)) {
						lock (level2.Points.SyncRoot) { level2.Points.Add(time, level2Value); }
					}
					
					if (!ReferenceEquals(upCrossing, null)) {
						lock (upCrossings.Points.SyncRoot) { upCrossings.Points.Add(upCrossing); }
					}
					
					if (!ReferenceEquals(downCrossing, null)) {
						lock (downCrossings.Points.SyncRoot) { downCrossings.Points.Add(downCrossing); }
					}
					
					time += timeIncrement;
				}
			}
			level1.Visible = (levelCrossingDetector != null) && levelCrossingDetector.IsActive && isLevelVisible; 
			level2.Visible = level1.Visible && (levelCrossingDetector.Hysteresis != 0.0);
			RefreshGraph();
		}*/
		
		protected void Update(object state)
		{
			bool level1Visible = (channel.LevelCrossingDetector != null) && channel.LevelCrossingDetector.IsActive && isLevelVisible;
			bool level2Visible = level1Visible && (channel.LevelCrossingDetector.Hysteresis != 0.0);
			double[] lastPoints;
			double t0;
			double dt;
			
			lock (channel.SyncRoot) {
				lastPoints = channel.GetLastPoints(historyLength);
				dt = channel.TimeIncrement;
				t0 = channel.Time - lastPoints.Length * dt;
			}
			
			lock (data.Points.SyncRoot) { data.Points.SetItems(lastPoints, t0, dt); }
			
			if (level1Visible) {
				double level1Value = channel.LevelCrossingDetector.Level - channel.LevelCrossingDetector.Hysteresis;
				double level2Value = channel.LevelCrossingDetector.Level + channel.LevelCrossingDetector.Hysteresis;
				double[] level1Y = new double[lastPoints.Length];
				double[] level2Y = level2Visible ? new double[lastPoints.Length] : null;
				double[] upX;
				double[] upY;
				double[] downX;
				double[] downY;
				
				for (int i = 0; i < level1Y.Length; i++) {
					level1Y[i] = level1Value;
					if (level2Visible) level2Y[i] = level2Value;
				}
				
				lock (level1.Points.SyncRoot) { level1.Points.SetItems(level1Y, t0, dt); }
				
				lock (channel.LevelCrossings.SyncRoot) {
					channel.LevelCrossings.GetCrossings(t0, out upX, out upY, out downX, out downY);
				}
				
				lock (upCrossings.Points.SyncRoot) { upCrossings.Points.SetItems(upX, upY); }
				
				lock (downCrossings.Points.SyncRoot) { downCrossings.Points.SetItems(downX, downY); }
				
				if (level2Visible) {
					lock (level2.Points.SyncRoot) { level2.Points.SetItems(level2Y, t0, dt); }
				}
			}
			
			level1.Visible = level1Visible;
			level2.Visible = level2Visible;
			
			RefreshGraph();
		}
		
		protected void RefreshGraph()
		{
			if (!ready) return;
			if (this.InvokeRequired) {
				this.Invoke(new MethodInvoker(RefreshGraph));
			} else {
				ready = false;
				this.Refresh();
				ready = true;
			}
		}
	}
}
