/*
 * Created by SharpDevelop.
 * User: phil
 * Date: 2010.04.14.
 * Time: 11:22
 * 
 * To change this template use Tools | Options | Coding | Edit Standard Headers.
 */
using System;
//
using TetheredSun.Core;

namespace Noise.Controls
{
	/// <summary>
	/// Description of CurvePointBuffer.
	/// </summary>
	public class DataPointBuffer : RingBuffer<Point<double>>
	{
		public DataPointBuffer(int capacity) : base(capacity) { }
		
		public DataPointBuffer() : base() { }
		
		
		public void Add(double x, double y)
		{
			Add(new Point<double>(x, y));
		}
				
		public bool UpdateBounds(out double xMinimum, out double xMaximum, out double yMinimum, out double yMaximum)
		{
			double x;
			double y;
			
			if (this.count < 1) {
				xMinimum = Double.NaN;
				xMaximum = Double.NaN;
				yMinimum = Double.NaN;
				yMaximum = Double.NaN;
				return false;
			}
			
			xMinimum = this.items[0].X;
			xMaximum = this.items[0].X;
			yMinimum = this.items[0].Y;
			yMaximum = this.items[0].Y;
	
			for (int i = 0; i < this.count; i++) {
				x = this.items[i].X;
				y = this.items[i].Y;
				
				if (x < xMinimum) {
					xMinimum = x;
				} else if (x > xMaximum) {
					xMaximum = x;
				}
				
				if (y < yMinimum) {
					yMinimum = y;
				} else if (y > yMaximum) {
					yMaximum = y;
				}
			}
			
			return true;
		}
		
	}
}
