﻿/*
 * Készítette a SharpDevelop.
 * Felhasználó: Ouroboros
 * Dátum: 2010.01.09.
 * Idő: 12:39
 * 
 * A sablon megváltoztatásához használja az Eszközök | Beállítások | Kódolás | Szabvány Fejlécek Szerkesztését.
 */
using System;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;

namespace Noise.Controls
{
	/// <summary>
	/// Description of NumericControl.
	/// </summary>
	public partial class LabelledTextBox : UserControl
	{
		[EditorBrowsable()]
		public event EventHandler ValueChanged;
		
		
		public LabelledTextBox()
		{
			InitializeComponent();
			textBox.Leave += HandleLeaveEvents;
			textBox.PreviewKeyDown += HandlePreviewKeyDownEvents;
		}
		
		[DesignerSerializationVisibility(DesignerSerializationVisibility.Content)]
		[EditorBrowsable()]
		public Label Label {
			get { return label; }
		}
		
		[DesignerSerializationVisibility(DesignerSerializationVisibility.Content)]
		[EditorBrowsable()]
		public TextBox TextBox {
			get { return textBox; }
		}
		
		public void HandlePreviewKeyDownEvents(object sender, PreviewKeyDownEventArgs e)
		{
			if (sender == textBox) {
				if (e.KeyData == Keys.Enter) {
					OnValueChanged(new EventArgs());
				}
			}
		}
		
		public void HandleLeaveEvents(object sender, EventArgs e)
		{
			if (sender == textBox) {
				OnValueChanged(new EventArgs());
			}
		}
		
		protected virtual void OnValueChanged(EventArgs e)
		{
			if (ValueChanged != null) {
				ValueChanged(this, e);
			}
		}
	}
}
