/*
 * Created by SharpDevelop.
 * User: phil
 * Date: 2010.02.25.
 * Time: 13:18
 * 
 * To change this template use Tools | Options | Coding | Edit Standard Headers.
 */
using System;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;
//
using TetheredSun.SignalAnalysis;

namespace Noise.Controls
{
	/// <summary>
	/// Description of LevelCrossingControl.
	/// </summary>
	public partial class LevelCrossingControl : UserControl
	{
		protected bool isActive;
		protected double level;
		protected double hysteresis;
		protected double length;
		
		public event EventHandler Updated;
		
		
		public LevelCrossingControl()
		{
			//
			// The InitializeComponent() call is required for Windows Forms designer support.
			//
			InitializeComponent();
			
			activeCheckBox.Click += HandleCheckBoxClickEvents;
			//
			levelNumericControl.Format = "f2";
			levelNumericControl.ValueChanged += HandleValueChangedEvents;
			//
			hysteresisNumericControl.Format = "f2";
			hysteresisNumericControl.ValueChanged += HandleValueChangedEvents;
			//
			lengthNumericControl.Format = "f3";
			lengthNumericControl.ValueChanged += HandleValueChangedEvents;
			
			Set(false, 1.0, 0.0, 0.1);
		}
		
		
		public bool IsActive {
			get { return isActive; }
		}
		
		public double Level {
			get { return level; }
		}
		
		public double Hysteresis {
			get { return hysteresis; }
		}
		
		public double Length {
			get { return length; }
		}
		
		
		public LevelCrossingDetector CreateLevelCrossingDetector()
		{
			LevelCrossingDetector detector = new LevelCrossingDetector(level);
			
			detector.Hysteresis = hysteresis;
			detector.IsActive = isActive;
			
			return detector;
		}
		
		public void Set(bool isActive, double level, double hysteresis, double length)
		{
			this.isActive = isActive;
			this.level = level;
			this.hysteresis = hysteresis;
			this.length = length;
			
			activeCheckBox.Checked = isActive;
			SetActiveState();
			//
			levelNumericControl.SetValue(level);
			//
			hysteresisNumericControl.SetValue(hysteresis);
			//
			lengthNumericControl.SetValue(length);
		}
		
		public void Set(LevelCrossingDetector detector, double objectLength)
		{
			Set(detector.IsActive, detector.Level, detector.Hysteresis, objectLength);
		}
		
		public void SetLevelCrossingDetector(LevelCrossingDetector detector)
		{
			detector.IsActive = isActive;
			detector.Level = level;
			detector.Hysteresis = hysteresis;
		}
		
		protected void HandleCheckBoxClickEvents(object sender, EventArgs e)
		{
			if (sender == activeCheckBox) {
				isActive = activeCheckBox.Checked;
				SetActiveState();
				OnUpdated(new EventArgs());
			}
		}
		
		protected void HandleValueChangedEvents(object sender, EventArgs e)
		{
			if (sender == levelNumericControl) {
				level = levelNumericControl.Value;
			} else if (sender == hysteresisNumericControl) {
				hysteresis = hysteresisNumericControl.Value;
			} else if (sender == lengthNumericControl) {
				length = lengthNumericControl.Value;
			} else {
				// If none of the above is the sender, skip the OnUpdated call:
				return;
			}
			
			OnUpdated(new EventArgs());
		}
		
		[EditorBrowsableAttribute()]
		protected override void OnEnabledChanged(EventArgs e)
		{
			base.OnEnabledChanged(e);
			if (!Enabled) isActive = false;
			activeCheckBox.Checked = isActive;
		}
		
		
		protected virtual void OnUpdated(EventArgs e)
		{
			if (Updated != null) {
				Updated(this, e);
			}
		}
		
		protected void SetActiveState()
		{
			levelNumericControl.Enabled = isActive;
			hysteresisNumericControl.Enabled = isActive;
			lengthNumericControl.Enabled = isActive;
		}
	}
}
