﻿/*
 * Készítette a SharpDevelop.
 * Felhasználó: Ouroboros
 * Dátum: 2010.01.16.
 * Idő: 17:30
 * 
 * A sablon megváltoztatásához használja az Eszközök | Beállítások | Kódolás | Szabvány Fejlécek Szerkesztését.
 */
using System;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;
//
using Noise.DataAcquisition;

namespace Noise.Controls
{
	/// <summary>
	/// Description of SensorControl.
	/// </summary>
	public partial class SensorControl : UserControl
	{
		protected bool readOnly;
		protected Sensor sensor;
		
		public event EventHandler SensorRecreated;
		public event EventHandler SensorUpdated;
		
		
		public SensorControl(Sensor sensor)
		{
			InitializeComponent();
			Sensor = sensor;
			// Set event handlers:
			typeComboBox.SelectionChangeCommitted += HandleSelectionChangeCommittedEvents;
				//
			nameTextBox.PreviewKeyDown += HandlePreviewKeyDownEvents;
			quantityTextBox.PreviewKeyDown += HandlePreviewKeyDownEvents;
			unitTextBox.PreviewKeyDown += HandlePreviewKeyDownEvents;
				//
			nameTextBox.Leave += HandleLeaveEvents;
			quantityTextBox.Leave += HandleLeaveEvents;
			unitTextBox.Leave += HandleLeaveEvents;
			//
			ReadOnly = false;
		}
		
		public SensorControl() : this(null) { }
		
		
		public bool ReadOnly {
			get { return readOnly; }
			set { 
				readOnly = value;
				typeComboBox.Enabled = !readOnly;
				nameTextBox.ReadOnly = readOnly;
				quantityTextBox.ReadOnly = readOnly;
				unitTextBox.ReadOnly = readOnly;
			}
		}
		
		public Sensor Sensor {
			get { return sensor; }
			set {
				sensor = value;
				UpdateSensorData();
			}
		}
		
		
		public override void Refresh()
		{
			UpdateSensorData();
			base.Refresh();
		}
		
		
		protected void HandleLeaveEvents(object sender, EventArgs e)
		{
			if (sender is TextBox) {
				if (UpdateTextData(sender as TextBox)) {
					OnSensorUpdated(new EventArgs());
				}	
			}
		}
		
		protected void HandlePreviewKeyDownEvents(object sender, PreviewKeyDownEventArgs e)
		{
			if (e.KeyData != Keys.Enter) return;
			if (sender is TextBox) {
				if (UpdateTextData(sender as TextBox)) {
					OnSensorUpdated(new EventArgs());
				}	
			}
		}
		
		protected void HandleSelectionChangeCommittedEvents(object sender, EventArgs e)
		{
			if (sender == typeComboBox) {
				RecreateSensor();
				OnSensorRecreated(new EventArgs());
			}
		}
		
		
		protected void UpdateSensorData()
		{
			if (sensor != null) {
				if (sensor is LinearSensor) {
					typeComboBox.SelectedIndex = 0;
				} else if (sensor is Thermistor) {
					typeComboBox.SelectedIndex = 1;
				}
				nameTextBox.Text = sensor.Name;
				quantityTextBox.Text = sensor.Quantity;
				unitTextBox.Text = sensor.Unit;
				parametersTextBox.Text = sensor.ParameterString;
			}
		}
		
		protected bool UpdateTextData(TextBox sender)
		{
			if (sensor == null) {
				RecreateSensor();
				OnSensorRecreated(new EventArgs());
				return true;
			}
			
			if (sender == nameTextBox) {
				if (sensor.Name == nameTextBox.Text) {
					return false;
				} else {
					sensor.Name = nameTextBox.Text;
					return true;
				}
			} else if (sender == quantityTextBox) {
				if (sensor.Quantity == quantityTextBox.Text) {
					return false;
				} else {
					sensor.Quantity = quantityTextBox.Text;
					return true;
				}
			} else if (sender == unitTextBox) {
				if (sensor.Unit == unitTextBox.Text) {
					return false;
				} else {
					sensor.Unit = unitTextBox.Text;
					if (sensor is Thermistor) unitTextBox.Text = sensor.Unit;
					return true;
				}
			}
			
			return false;
		}
		
		[EditorBrowsableAttribute()]
		protected override void OnInvalidated(InvalidateEventArgs e)
		{
			UpdateSensorData();
			base.OnInvalidated(e);
		}
		
		protected virtual void OnSensorRecreated(EventArgs e)
		{
			if (SensorRecreated != null) {
				SensorRecreated(this, e);
			}
		}
		
		protected virtual void OnSensorUpdated(EventArgs e)
		{
			if (SensorUpdated != null) {
				SensorUpdated(this, e);
			}
		}
		
		protected void RecreateSensor()
		{
			switch (typeComboBox.SelectedIndex) {
				case 0:
					sensor = new LinearSensor();
					break;
				case 1:
					sensor = new Thermistor();
					break;
					// TODO: Implement other sensor types.
				default:
					return;
			}
			
			Refresh();
		}
	}
}
