/*
 * Created by SharpDevelop.
 * User: phil
 * Date: 2010.04.14.
 * Time: 13:25
 * 
 * To change this template use Tools | Options | Coding | Edit Standard Headers.
 */
using System;
using System.Drawing;

namespace Noise.Controls
{
	/// <summary>
	/// Description of Symbol.
	/// </summary>
	public class Symbol
	{
		protected SymbolType	type;
		protected Pen			border = new Pen(Color.Black);
		protected Brush			fill = new SolidBrush(Color.DarkSlateBlue);
		protected float			size = 10.0f;
		
		private Symbol(SymbolType type)
		{
			this.type = type;
		}
		
		public float Size {
			get { return size; }
			set { size = value; }
		}
		
		public Pen Border {
			get { return border; }
			set { border = value; }
		}
		
		public Brush Fill {
			get { return fill; }
			set { fill = value; }
		}
		
		
		
		public static Symbol Circle {
			get { return new Symbol(SymbolType.Circle); }
		}
		
		public static Symbol DownTriangle {
			get { return new Symbol(SymbolType.DownTriangle); }
		}
		
		public static Symbol Square {
			get { return new Symbol(SymbolType.Square); }
		}
		
		public static Symbol UpTriangle {
			get { return new Symbol(SymbolType.UpTriangle); }
		}
		
		internal void Draw(Graphics graphics, PointF centre)
		{
			if (type == SymbolType.None) {
				return;
			} else if (type == SymbolType.Circle) {
				RectangleF layoutRectangle = new RectangleF(
					centre.X - size / 2,
					centre.Y - size / 2,
					size,
					size
				);
				
				if (fill != null) {
					graphics.FillEllipse(fill, layoutRectangle);
				}
				
				if (border.Width > 0) {
					graphics.DrawEllipse(border, layoutRectangle);
				}
			} else if (type == SymbolType.Square) {
				Rectangle layoutRectangle = new Rectangle(
					(int)(centre.X - size / 2),
					(int)(centre.Y - size / 2),
					(int)size,
					(int)size
				);
				
				if (fill != null) {
					graphics.FillRectangle(fill, layoutRectangle);
				}
				
				if (border.Width > 0) {
					graphics.DrawRectangle(border, layoutRectangle);
				}
			} else if (type == SymbolType.UpTriangle) {
				PointF[] points = new PointF[3];
				float r = size / 2;
				double angle = Math.PI / 6;
				
				points[0].X = (float)(centre.X - r * Math.Cos(angle));
				points[0].Y = (float)(centre.Y + r * Math.Sin(angle));
				points[1].X = (float)(centre.X + r * Math.Cos(angle));
				points[1].Y = points[0].Y;
				points[2].X = centre.X;
				points[2].Y = centre.Y - size / 2;
				
				if (fill != null) {
					graphics.FillPolygon(fill, points);
				}
				
				if (border.Width > 0) {
					graphics.DrawPolygon(border, points);
				}
			} else if (type == SymbolType.DownTriangle) {
				PointF[] points = new PointF[3];
				float r = size / 2;
				double angle = Math.PI / 6;
				
				points[0].X = (float)(centre.X - r * Math.Cos(angle));
				points[0].Y = (float)(centre.Y - r * Math.Sin(angle));
				points[1].X = (float)(centre.X + r * Math.Cos(angle));
				points[1].Y = points[0].Y;
				points[2].X = centre.X;
				points[2].Y = centre.Y + size / 2;
				
				if (fill != null) {
					graphics.FillPolygon(fill, points);
				}
				
				if (border.Width > 0) {
					graphics.DrawPolygon(border, points);
				}
			}
		}
	}
}
