/*
 * Created by SharpDevelop.
 * User: phil
 * Date: 2010.03.03.
 * Time: 9:09
 * 
 * To change this template use Tools | Options | Coding | Edit Standard Headers.
 */
using System;
using System.Xml;
//
using TetheredSun.Core;

namespace Noise.DataAcquisition
{
	public class Averages : IXmlConvertible
	{
		protected int number;
		protected byte code;
		
		protected Averages(int number, byte code)
		{
			this.number = number;
			this.code = code;
		}
		
		public byte Code {
			get { return code; }
		}
		
		public int Number {
			get { return number; }
		}
		
		
		public static Averages One {
			get { return new Averages(1, 0); }
		}
		
		public static Averages Four {
			get { return new Averages(4, 1); }
		}
		
		public static Averages Eight {
			get { return new Averages(8, 2); }
		}
		
		public static Averages Sixteen {
			get { return new Averages(16, 3); }
		}
		
		public static Averages Undefined {
			get { return new Averages(-1, (byte)8); }
		}
		
		
		public static Averages FromCode(byte code)
		{
			int n;
			switch (code) {
				case 1:
					n = 4;
					break;
				case 2:
					n = 8;
					break;
				case 3:
					n = 16;
					break;
				case 0:
				default:
					n = 1;
					break;
			}
			return new Averages(n, code);
		}
		
		public void FromXml(XmlElement xmlElement)
		{
			if (xmlElement.Name != "Averages") {
				Exception exception = new ArgumentException("Invalid element name.");
				
				exception.Data.Add("Expected name", "Averages");
				exception.Data.Add("Received name", xmlElement.Name);
				
				throw exception;
			}
			
			int parsedInt;
			
			if (Int32.TryParse(xmlElement.InnerXml, out parsedInt)) {
				Set(parsedInt);
			} else {
				Set(1);
			}
		}
		
		public override string ToString()
		{
			switch (code) {
				case 1:
					return "Four";
				case 2:
					return "Eight";
				case 3:
					return "Sixteen";
				case 0:
				default:
					return "One";
			}
		}
		
		public XmlElement ToXml(XmlDocument context)
		{
			XmlElement averagesXml = context.CreateElement("Averages");
			
			averagesXml.InnerXml = number.ToString();
			
			return averagesXml;
		}
		
		
		protected void Set(int number)
		{
			switch (number) {
				case 4:
					code = 1;
					number = 4;
					break;
				case 8:
					code = 2;
					number = 8;
					break;
				case 16:
					code = 3;
					number = 8;
					break;
				case 1:
				default:
					code = 0;
					number = 1;
					break;
			}
		}
	}
}
