﻿/*
 * Készítette a SharpDevelop.
 * Felhasználó: phil
 * Dátum: 2009.11.21.
 * Idő: 14:40
 * 
 * A sablon megváltoztatásához használja az Eszközök | Beállítások | Kódolás | Szabvány Fejlécek Szerkesztését.
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.Threading;
//
using TetheredSun.Core;
using TetheredSun.SignalAnalysis;

namespace Noise.DataAcquisition
{
	/// <summary>
	/// A queue of double values from a single input channel, along with the channel information.
	/// </summary>
	public class Channel : RingBuffer<double>
	{
		protected ChannelInfo channelInfo;
		protected double currentValue;
		protected double time = 0.0;
		protected double timeIncrement;
		protected LevelCrossingDetector levelCrossingDetector = null;
		protected LevelCrossingCycleCollection levelCrossings = new LevelCrossingCycleCollection(1000);
		
		
		public Channel(ChannelInfo channelInfo, double timeIncrement, int capacity) : base(capacity)
		{
			this.channelInfo = channelInfo;
			this.timeIncrement = timeIncrement;
		}
		
		public Channel(ChannelInfo channelInfo, double timeIncrement) : this(channelInfo, timeIncrement, DefaultCapacity) { }
		
		public Channel(ChannelInfo channelInfo) : this(channelInfo, Double.NaN) { }
		
		
		
		public ChannelInfo ChannelInfo {
			get { return channelInfo; }
		}
		
		public double CurrentValue {
			get { return currentValue; }
		}
		
		public LevelCrossingDetector LevelCrossingDetector {
			get { return levelCrossingDetector; }
			set { levelCrossingDetector = value; }
		}
		
		public LevelCrossingCycleCollection LevelCrossings {
			get { return levelCrossings; }
		}
		
		public double Time {
			get { return time; }
		}
		
		public double TimeIncrement {
			get { return timeIncrement; }
			set { timeIncrement = value; }
		}
		
		
		public override void Add(double item)
		{
			currentValue = (channelInfo.Sensor != null) ? channelInfo.Sensor.GetValue(item) : item;
			
			base.Add(currentValue);
			if ((levelCrossingDetector != null) && (levelCrossingDetector.IsActive)) {
				LevelCrossing crossing;
				if (levelCrossingDetector.Test(time, currentValue, out crossing)) {
					lock (levelCrossings.SyncRoot) { levelCrossings.Append(crossing); }
				}
			}
			time += timeIncrement;
		}
		
		public override void Clear()
		{
			base.Clear();
			levelCrossings.Clear();
			time = 0.0;
		}
		
	}
}
