﻿/*
 * Készítette a SharpDevelop.
 * Felhasználó: phil
 * Dátum: 2009.11.21.
 * Idő: 14:22
 * 
 * A sablon megváltoztatásához használja az Eszközök | Beállítások | Kódolás | Szabvány Fejlécek Szerkesztését.
 */
using System;
using System.Collections.Generic;

namespace Noise.DataAcquisition
{
	/// <summary>
	/// A class encapsulating the properties of an input channel of an ISerialDataCollector.
	/// </summary>
	public class ChannelInfo
	{
		protected string name;
		protected double gain;
		protected double timeOffset = 0.0;
		protected Sensor sensor;
		
		
		internal ChannelInfo(string name, double gain, double timeOffset, Sensor sensor)
		{
			this.name = name;
			this.gain = gain;
			this.timeOffset = timeOffset;
			this.sensor = sensor;
		}
		
		public ChannelInfo(string name, double gain, Sensor sensor) : this(name, gain, 0.0, sensor) { }
		
		public ChannelInfo(string name, double gain) : this(name, gain, 0.0, null) { }
		
		public ChannelInfo(string name) : this(name, 1.0, 0.0, null) { }

		
		public string Name {
			get { return name; }
		}
		
		public double Gain {
			get { return gain; }
		}
		
		public double TimeOffset {
			get { return timeOffset; }
			internal set { timeOffset = value; }
		}
		
		public Sensor Sensor {
			get { return sensor; }
			set { sensor = value; }
		}
	}
}
