﻿/*
 * Készítette a SharpDevelop.
 * Felhasználó: Ouroboros
 * Dátum: 2010.02.28.
 * Idő: 13:01
 * 
 * A sablon megváltoztatásához használja az Eszközök | Beállítások | Kódolás | Szabvány Fejlécek Szerkesztését.
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.IO;
using System.Text;
using System.Threading;
//
using TetheredSun.Core;

namespace Noise.DataAcquisition
{
	/// <summary>
	/// Description of DataBuffer.
	/// </summary>
	public class ChannelList : List<Channel>
	{
		protected object syncRoot;
		
		public ChannelList() : base()
		{
			syncRoot = (this as ICollection).SyncRoot;
		}
		
		public object SyncRoot {
			get { return syncRoot; }
		}
		
		
		/*public void Save(string path, string header, string format, double dt)
		{
			double[] item;
			string line;
			
			if (String.IsNullOrEmpty(format)) format = "f3";
			

			if (this.count > 0) {
				using (StreamWriter writer = new StreamWriter(path, false, Encoding.UTF8, this.count)) {
					if (!String.IsNullOrEmpty(header)) writer.WriteLine(header);
					
					for (int i = 0; i < this.count; i++) {
						item = this[i];
						line = (i * dt).ToString(format) + separator;
						
						for (int j = 0; j < item.Length; j++) {
							line += item[j].ToString(format);
							if (j < item.Length - 1) line += separator;
						}
						
						writer.WriteLine(line);
					}
				}
			}*/
		
			public void Save(string path, string format, string separator)
			{
				if (this.Count < 1) return;
				if (String.IsNullOrEmpty(format)) format = "f3";
				if (String.IsNullOrEmpty(separator)) separator = "\t";
				
				int rowCount = this[0].Count;
				double dt = this[0].TimeIncrement;
				string line;
				string header = String.Format("// Time increment: {0} s", dt);
				
				
				// Construct header.
				for (int i = 0; i < this.Count; i++) {
					header += Environment.NewLine +
						String.Format("// Channel {0}: {1}", this[i].ChannelInfo.Name, (this[i].ChannelInfo.Sensor == null) ? "U [V]" :
					              this[i].ChannelInfo.Sensor.GetLabel());
				}
				
				// Get row count.
				for (int i = 1; i < this.Count; i++) {
					if (this[i].Count < rowCount) rowCount = this[i].Count;
				}
				
				if (rowCount < 1) return;
				
				using (StreamWriter writer = new StreamWriter(path, false, Encoding.UTF8)) {
					if (!String.IsNullOrEmpty(header)) writer.WriteLine(header);
					
					for (int i = 0; i < rowCount; i++) {
						line = (i * dt).ToString(format) + separator;
						
						for (int j = 0; j < this.Count; j++) {
							line += this[j][i].ToString(format);
							if (j < this.Count - 1) line += separator;
						}
						
						writer.WriteLine(line);
					}
				}
			}
	}
}
