﻿/*
 * Készítette a SharpDevelop.
 * Felhasználó: phil
 * Dátum: 2008.08.11.
 * Idő: 14:56
 * Verzió: 0.0.0
 * Legutóbbi változtatás időpontja:
 * Változtatások:
 * Teendők:
 */

using System;
using System.IO.Ports;

namespace Noise.DataAcquisition
{
	/// <summary>
	/// Description of ClassicSerialPort.
	/// </summary>
	public class ClassicSerialPort : SerialPort, ISerialPort
	{
		protected object syncRoot = new Object();
		
		public ClassicSerialPort() : base() { }
		
		public ClassicSerialPort(string portName) : base(portName) { }
		
		
		public object SyncRoot {
			get { return syncRoot; }
		}
		
		
		public void Initialise() { }

		/// <summary>
		/// Reads the specified number of bytes. It waits till this number of bytes is accumulated or a timeout occurs.
		/// </summary>
		/// <param name="count">The number of bytes to read.</param>
		/// <returns>The bytes read from the port.</returns>
		public byte[] Read(int count)
		{
			byte[] bytesRead = new byte[count];
			Read(bytesRead, 0, count);
			return bytesRead;
		}
		
		
		public byte[] Read()
		{
			if (BytesToRead > 0) {
				byte[] bytesRead = new byte[BytesToRead];
				Read(bytesRead, 0, BytesToRead);
				return bytesRead;
			} else {
				return null;
			}
		}
		
		public void Write(byte[] buffer)
		{
			Write(buffer, 0, buffer.Length);
		}
		
	}
}
