﻿/*
 * Készítette a SharpDevelop.
 * Felhasználó: Ouroboros
 * Dátum: 2010.01.08.
 * Idő: 15:04
 * 
 * A sablon megváltoztatásához használja az Eszközök | Beállítások | Kódolás | Szabvány Fejlécek Szerkesztését.
 */
using System;
using System.Collections.Generic;

namespace Noise.DataAcquisition
{
	/// <summary>
	/// A delegate for methods which convert voltage values into other physical quantities, such as pressure.
	/// </summary>
	/// <returns>The voltage converted to a physical quantity.</returns>
	public delegate double SensorConverter(double voltage);
	
	public class UserSensor : Sensor
	{
		protected SensorConverter converter;
		protected string parameterString;
		
		
		public UserSensor(string name, string quantity, string unit, SensorConverter converter) : base(name, quantity, unit)
		{
			this.converter = converter;
		}
		
		public UserSensor(string name, string quantity, string unit) : this(name, quantity, unit, null) { }
		
		public UserSensor() : this(String.Empty, String.Empty, String.Empty, null) { }
		
		
		public SensorConverter Converter {
			get { return converter; }
			set { converter = value; }
		}
		
		
		public override void Calibrate(IList<double> voltageValues, IList<double> quantityValues)
		{
			throw new NotImplementedException();
		}
		
		public override Sensor Clone()
		{
			return new UserSensor(name, quantity, unit, converter);
		}
		
		public override string GetParameterString(params string[] format)
		{
			return parameterString;
		}
		
		public override double GetValue(double voltage)
		{
			return (converter != null) ? converter(voltage) : voltage;
		}
		
		public override double[] GetValues(double[] voltages)
		{
			if (converter == null) {
				return voltages;
			}
			double[] values = new double[voltages.Length];
			
			for (int i = 0; i < values.Length; i++) {
				values[i] = converter(voltages[i]);
			}
			
			return values;
		}
	}
}
