﻿/*
 * Készítette a SharpDevelop.
 * Felhasználó: Ouroboros
 * Dátum: 2009.05.31.
 * Idő: 12:07
 * 
 * A sablon megváltoztatásához használja az Eszközök | Beállítások | Kódolás | Szabvány Fejlécek Szerkesztését.
 */
using System;
using System.Collections.Generic;
using System.IO;
using System.Text;
using TetheredSun.Core.Mathematics;

namespace TetheredSun.Core
{
	public enum ComplexRepresentation {
		AbsoluteValue,
		RealImaginary,
		Imaginary,
		Real
	}
	
	/// <summary>
	/// Description of ComplexTextWriter.
	/// </summary>
	public class ComplexTextWriter : DataTextWriter
	{
		protected ComplexRepresentation representation;
		
		
		public ComplexTextWriter(Stream stream, ComplexRepresentation representation) : base(stream)
		{
			this.representation = representation;
		}
		
		public ComplexTextWriter(string path, bool append, ComplexRepresentation representation) :
			base(path, append)
		{
			this.representation = representation;
		}
		
		public ComplexTextWriter(string path, ComplexRepresentation representation) :
			this(path, false, representation) { }
		
		public ComplexTextWriter(string path) :
			this(path, false, ComplexRepresentation.AbsoluteValue) { }

		
		public ComplexRepresentation Representation {
			get { return representation; }
			set { representation = value; }
		}
		
		public void WriteAll(List<string> header, Complex[][] data)
		{
			WriteHeader(header);
			WriteData(data);
		}
		
		public void WriteData(Complex[][] data)
		{
			if ((data != null) && (data.Length > 0) && (data[0].Length > 0)) {
				string line = String.Empty;
				if (representation == ComplexRepresentation.AbsoluteValue) {
					for (int i = 0; i < data.Length; i++) {
						line = data[i][0].Abs().ToString(formatString);
						for (int j = 1; j < data[i].Length; j++) {
							line += separator + data[i][j].Abs().ToString(formatString);
						}
						this.WriteLine(line);
					}
				} else if (representation == ComplexRepresentation.Imaginary) {
					for (int i = 0; i < data.Length; i++) {
						line = data[i][0].Im.ToString(formatString);
						for (int j = 1; j < data[i].Length; j++) {
							line += separator + data[i][j].Im.ToString(formatString);
						}
						this.WriteLine(line);
					}
				} else if (representation == ComplexRepresentation.Real) {
					for (int i = 0; i < data.Length; i++) {
						line = data[i][0].Re.ToString(formatString);
						for (int j = 1; j < data[i].Length; j++) {
							line += separator + data[i][j].Re.ToString(formatString);
						}
						this.WriteLine(line);
					}
				} else if (representation == ComplexRepresentation.RealImaginary) {
					for (int i = 0; i < data.Length; i++) {
						line = data[i][0].ToString(formatString);
						for (int j = 1; j < data[i].Length; j++) {
							line += separator + data[i][j].ToString(formatString);
						}
						this.WriteLine(line);
					}
				}
			}
		}
	}
}
