﻿/*
 * Készítette a SharpDevelop.
 * Felhasználó: phil
 * Dátum: 2009.07.20.
 * Idő: 15:53
 * 
 * A sablon megváltoztatásához használja az Eszközök | Beállítások | Kódolás | Szabvány Fejlécek Szerkesztését.
 */
using System;
using System.Collections.Generic;
using TetheredSun.Core.Mathematics;

namespace TetheredSun.Core
{
	public static class ConversionTools
	{
		public static byte[] GetBytes(IList<double> list)
		{
			byte[] bytes = new byte[8 * list.Count];
			byte[] current;
			
			for (int i = 0; i < list.Count; i++) {
				current = BitConverter.GetBytes(list[i]);
				for (int j = 0; j < current.Length; j++) {
					bytes[i * current.Length + j] = current[j];
				}
			}
			
			return bytes;
		}
		
		public static byte[] GetBytes(IList<Complex> list)
		{
			double[] doubleList = new double[2 * list.Count];
			
			for (int i = 0; i < list.Count; i++) {
				doubleList[2 * i] = list[i].Re;
				doubleList[2 * i + 1] = list[i].Im;
			}
			
			return GetBytes(doubleList);
		}
		
		public static byte[] GetBytes(Complex[][] matrix)
		{
			List<byte> bytes = new List<byte>();
			
			for (int i = 0; i < matrix.Length; i++) {
				bytes.AddRange(GetBytes(matrix[i]));
			}
			
			return bytes.ToArray();
		}
		
		public static Complex[] GetComplexArray(byte[] bytes, int offset, int length)
		{
			Complex[] complexArray = new Complex[length / 16];
			
			for (int i = 0; i < complexArray.Length; i++) {
				complexArray[i] = new Complex(BitConverter.ToDouble(bytes, offset + i * 16),  BitConverter.ToDouble(bytes, offset + i * 16 + 8));
			}
			
			return complexArray;
		}
		
		public static Complex[] GetComplexArray(byte[] bytes)
		{
			return GetComplexArray(bytes, 0, bytes.Length);
		}
		
		public static Complex[][] GetComplexMatrix(byte[] bytes, int rows, int columns)
		{
			Complex[][] matrix = new Complex[rows][];
			int offset = 0;
			int length = columns * 16;
			
			for (int i = 0; i < rows; i++) {
				matrix[i] = GetComplexArray(bytes, offset, length);
				offset += length;
			}
			
			return matrix;
		}
		
		public static double[] GetDoubleArray(byte[] bytes, int offset, int length)
		{
			double[] array = new double[length / 8];
			
			for (int i = 0; i < array.Length; i++) {
				array[i] = BitConverter.ToDouble(bytes, offset + i * 8);
			}
			
			return array;
		}
		
		public static double[] GetDoubleArray(byte[] bytes)
		{
			return GetDoubleArray(bytes, 0, bytes.Length);
		}
		
		public static List<double> GetDoubleList(byte[] bytes)
		{
			List<double> list = new List<double>();
			
			for (int i = 0; i < bytes.Length - 8; i += 8) {
				list.Add(BitConverter.ToDouble(bytes, i));
			}
			
			return list;
		}
	}
}
