﻿/*
 * Készítette a SharpDevelop.
 * Felhasználó: phil
 * Dátum: 2009.07.14.
 * Idő: 8:30
 * 
 * A sablon megváltoztatásához használja az Eszközök | Beállítások | Kódolás | Szabvány Fejlécek Szerkesztését.
 */
using System;
using System.Collections.Generic;
using System.IO;

namespace TetheredSun.Core
{
	/// <summary>
	/// Description of DataWriter.
	/// </summary>
	public class DataTextWriter : StreamWriter
	{
		protected string axisPrefix = "#";
		protected string headerPrefix = "//";
		protected string separator = "\t";
		protected string formatString = "f6";
		
		public DataTextWriter(Stream stream) : base(stream) { }
		
		public DataTextWriter(string path, bool append) : base(path, append) { }
		
		public string AxisPrefix {
			get { return axisPrefix; }
			set { axisPrefix = value; }
		}
		
		public string HeaderPrefix {
			get { return headerPrefix; }
			set { headerPrefix = value; }
		}
		
		public string Separator {
			get { return separator; }
			set { separator = value; }
		}
		
		public string FormatString {
			get { return formatString; }
			set { formatString = value; }
		}
		
		
		public void WriteAxis(string axisLabel, double[] axisValues)
		{
			if ((axisValues != null) && (axisValues.Length > 0)) {
				string line = axisPrefix + " " + axisLabel + ":";
				for (int i = 0; i < axisValues.Length; i++) {
					line += this.separator + axisValues[i].ToString(this.formatString);
				}
				this.WriteLine(line);
			}
		}
		
		public void WriteData(double[][] data)
		{
			string line = String.Empty;
			
			for (int i = 0; i < data.Length; i++) {
				WriteRow(data[i]);
			}
		}
		
		public void WriteHeader(IList<string> header)
		{
			if ((header != null) && (header.Count > 0)) {
				foreach (string headerLine in header) {
					this.WriteLine(headerPrefix + " " + headerLine);
				}
			}
		}
		
		public void WriteHeaderLine(string line)
		{
			this.WriteLine(headerPrefix + " " + line);
		}
		
		public void WriteRow(double[] row)
		{
			string line = row[0].ToString(formatString);
			
			for (int i = 1; i < row.Length; i++) {
				line += separator + row[i].ToString(formatString);
			}
			
			this.WriteLine(line);
		}
	}
}
