﻿/*
 * Készítette a SharpDevelop.
 * Felhasználó: phil
 * Dátum: 2009.04.28.
 * Idő: 13:44
 * 
 * A sablon megváltoztatásához használja az Eszközök | Beállítások | Kódolás | Szabvány Fejlécek Szerkesztését.
 */

using System;
using System.Collections;
using System.Collections.Generic;
using System.Windows.Forms;

namespace TetheredSun.Core
{
	public static class ExceptionReporter
	{
		public static string Report(Exception exception, bool showStackTrace)
		{
			string text = Labels.Message + ": " + exception.Message + Environment.NewLine;
			string separator = "* * *"  + Environment.NewLine;
			
			text += separator + Labels.Source + ": " + exception.Source + Environment.NewLine;
			text += separator + Labels.Method + ": " + exception.TargetSite + Environment.NewLine;
			if ((exception.Data != null) && (exception.Data.Count > 0)) {
				text += separator + Labels.Data + ":" + Environment.NewLine;
				foreach (DictionaryEntry entry in exception.Data) {
					text += entry.Key.ToString() + ": ";
					text += entry.Value.ToString() + Environment.NewLine;
				}
			}
			
			if (showStackTrace) {
				text += separator + Labels.StackTrace + ": " + exception.StackTrace + Environment.NewLine;
			}
			
			return text;
		}
		
		public static string Report(Exception exception)
		{
			return Report(exception, false);
		}
		
		public static void Show(Exception exception, bool showStackTrace)
		{
			string caption = exception.GetType().ToString();
			
			MessageBox.Show(Report(exception, showStackTrace), caption, MessageBoxButtons.OK, MessageBoxIcon.None);
		}
		
		public static void Show(Exception exception)
		{
			Show(exception, false);
		}
	}
}
