﻿/*
 * Készítette a SharpDevelop.
 * Felhasználó: phil
 * Dátum: 2009.06.15.
 * Idő: 10:46
 * 
 * A sablon megváltoztatásához használja az Eszközök | Beállítások | Kódolás | Szabvány Fejlécek Szerkesztését.
 */

using System;
using System.Drawing;

namespace TetheredSun.Core
{
	/// <summary>
	/// Description of FontInfo.
	/// </summary>
	public class FontInfo
	{
		protected string name;
		protected FontStyle style;
		protected float size;
		
		public FontInfo(string name, FontStyle style, float size)
		{
			this.name = name;
			this.style = style;
			this.size = size;
		}
		
		public FontInfo(string name, float size) : this(name, FontStyle.Regular, size) { }
		
		public FontInfo(string name) : this(name, FontStyle.Regular, 12.0f) { }
			
		
		public string Name {
			get { return name; }
			set { name = value; }
		}
		
		public FontStyle Style {
			get { return style; }
			set { style = value; }
		}
		
		public float Size {
			get { return size; }
			set { size = value; }
		}
		
		public static explicit operator FontInfo(Font font)
		{
			return new FontInfo(font.FontFamily.Name, font.Style, font.Size);
		}
		
		public static explicit operator Font(FontInfo fontInfo)
		{
			return new Font(fontInfo.Name, fontInfo.Size, fontInfo.Style);
		}
	}
}
