﻿/*
 * Készítette a SharpDevelop.
 * Felhasználó: Ouroboros
 * Dátum: 2010.01.17.
 * Idő: 14:55
 * 
 * A sablon megváltoztatásához használja az Eszközök | Beállítások | Kódolás | Szabvány Fejlécek Szerkesztését.
 */
using System;
using System.Collections.Generic;

namespace TetheredSun.Core.Mathematics
{
	public class LinearFitResults
 	{
 		protected double slope;
 		protected double intercept;
 		protected double rSquare;
 		
		public LinearFitResults(double intercept, double slope, double rSquare)
		{
			this.intercept = intercept;
			this.slope = slope;
			this.rSquare = rSquare;
		}
		
		public LinearFitResults() : this(Double.NaN, Double.NaN, Double.NaN) { }
		
		public double Intercept {
			get { return intercept; }
			set { intercept = value; }
		}
		
		public double Slope {
			get { return slope;}
			set { slope = value; }
		}
 
		public double RSquare {
			get { return rSquare; }
			set { rSquare = value; }
		}
		
		public string ToString(params string[] format)
		{
			string interceptFormat = ((format != null) && (format.Length > 0)) ? format[0] : "g2";
			string slopeFormat = ((format != null) && (format.Length > 1)) ? format[1] : "g2";
			string rSquareFormat = ((format != null) && (format.Length > 2)) ? format[2] : "g2";
			string returnString = "Intercept: " + intercept.ToString(interceptFormat) + Environment.NewLine; 
			
			returnString += "Slope: " + slope.ToString(slopeFormat);
			returnString += Environment.NewLine;
			returnString += "Squared correlation coefficient (R^2): " + rSquare.ToString(rSquareFormat);
			
			return returnString;
		}
		
		public override string ToString()
		{
			return ToString("g2", "g2", "g2");
		}
 	}
}
