/*
 * Created by SharpDevelop.
 * User: phil
 * Date: 2010.03.04.
 * Time: 15:48
 * 
 * To change this template use Tools | Options | Coding | Edit Standard Headers.
 */
using System;

namespace TetheredSun.Core
{
	/// <summary>
	/// Description of Point.
	/// </summary>
	public class Point<T> : IEquatable<Point<T>> where T : struct, IEquatable<T>
	{
		private T x;
		private T y;
		
		public Point(T x, T y)
		{
			this.x = x;
			this.y = y;
		}
		
		
		public T X {
			get { return x; }
		}
		
		public T Y {
			get { return y; }
		}
		
		
		public override bool Equals(object obj)
		{
			if (obj is Point<T>)
				return Equals((Point<T>)obj); // use Equals method below
			else
				return false;
		}
		
		public bool Equals(Point<T> other)
		{
			if (Object.ReferenceEquals(other, null)) return false;
			return this.x.Equals(other.x) && this.y.Equals(other.y);
		}
		
		public override int GetHashCode()
		{
			// Combine the hash codes of all members here (e.g. with XOR operator ^)
			return x.GetHashCode() ^ y.GetHashCode();
		}
		
		public static bool operator ==(Point<T> left, Point<T> right)
		{
			if (Object.ReferenceEquals(left, right)) return true;
			if (Object.ReferenceEquals(left, null)) {
				return false;	// If 'right' had been also null we would have already returned true.
			}
			return left.Equals(right);
		}
		
		public static bool operator !=(Point<T> left, Point<T> right)
		{
			return !(left == right);
		}
	}
}
