﻿/*
 * Készítette a SharpDevelop.
 * Felhasználó: Ouroboros
 * Dátum: 2010.02.27.
 * Idő: 15:16
 * 
 * A sablon megváltoztatásához használja az Eszközök | Beállítások | Kódolás | Szabvány Fejlécek Szerkesztését.
 */
using System;
using System.Collections;
using System.Collections.Generic;

namespace TetheredSun.Core
{
	/// <summary>
	/// Description of RingBuffer.
	/// </summary>
	public class RingBuffer<T>
	{
		public static int DefaultCapacity = 1024;
		//
		protected object syncRoot = new Object();
		protected T[] items;
		protected int capacity;
		protected int count;
		protected int position;
		
		public RingBuffer(int capacity)
		{
			this.capacity = capacity;
			this.count = 0;
			this.position = -1;
			this.items = new T[capacity];
		}
		
		public RingBuffer() : this(DefaultCapacity) { }
		
		
		public int Capacity {
			get { return capacity; }
			set { Resize(value); }
		}
		
		public int Count {
			get { return count; }
		}
		
		public object SyncRoot {
			get { return syncRoot; }
		}
		
		public T this[int index] {
			get { return items[GetInternalIndex(index)]; }
			set { items[GetInternalIndex(index)] = value; }
		}
		
		
		
		public virtual void Add(T item)
		{
			position++;
			if (position >= capacity) position = 0;
			if (count < capacity) count++;
			
			items[position] = item;
		}
		
		public virtual void Clear()
		{
			this.count = 0;
			this.position = -1;
			this.items = new T[capacity];
		}
		
		public T[] GetLastPoints(int length)
		{
			length = Math.Min(count, length);
			int startIndex = count - length;
			
			return GetOrderedArray(startIndex, length);
		}
		
		public T[] GetOrderedArray(int startIndex, int length)
		{
			if (startIndex >= count) startIndex = count - 1;
			if (startIndex < 0) startIndex = 0;
			if (length < 1) length = 1;
			T[] orderedArray = new T[length];
			
			
			if (count < capacity) {
				Array.Copy(items, startIndex, orderedArray, 0, Math.Min(count, length));
			} else {
				int start = GetInternalIndex(startIndex);
				int part1Length = Math.Min(length, count - start);
				int part2Length = length - part1Length;
				
				Array.Copy(items, start, orderedArray, 0, part1Length);
				
				if (part2Length > 0) Array.Copy(items, 0, orderedArray, part1Length, part2Length);
			}
			
			return orderedArray;
		}
		
		protected int GetInternalIndex(int index)
		{
			return (count < capacity) ? index : (index + position + 1) % capacity;
		}
		
		protected void Resize(int newCapacity)
		{
			T[] oldItems = null;
			double oldCount = count;
			
			if (oldCount > 0) oldItems = GetOrderedArray(0, count);
			
			if (newCapacity < 1) newCapacity = 1;
			items = new T[newCapacity];
			position = -1;
			capacity = newCapacity;
			count = 0;
			
			if (oldCount < 1) return;
		
			foreach (T item in oldItems) {
				Add(item);
			}
		}
	}
}
