﻿/*
 * Készítette a SharpDevelop.
 * Felhasználó: Ouroboros
 * Dátum: 2010.01.17.
 * Idő: 15:04
 * 
 * A sablon megváltoztatásához használja az Eszközök | Beállítások | Kódolás | Szabvány Fejlécek Szerkesztését.
 */
using System;
using System.Collections.Generic;

namespace TetheredSun.Core.Mathematics
{
	/// <summary>
	/// Description of Statistics.
	/// </summary>
	public static class Statistics
	{
		public static LinearFitResults GetLinearFit(IList<double> xValues, IList<double> yValues)
		{
 			if ((xValues == null) || (yValues == null))
 				throw new NullReferenceException("The fit cannot be performed: at least one of the sequences" +
			                                        " is a null reference.");
			if (xValues.Count != yValues.Count)
			     throw new InvalidOperationException("The fit cannot be performed: the numbers of" +
			                                        " points in the sequences differ.");
			double sum0 = 0.0;
			double sum1 = 0.0;
			double sum2 = 0.0;
			double sum3 = 0.0;
			double sum4 = 0.0;
			double meanX;
			double meanY;
			double x;
			double y;
			int n = xValues.Count;
			LinearFitResults results = new LinearFitResults();
			
			for (int i = 0; i < n; i++) {
				sum0 += xValues[i];
				sum1 += yValues[i];
			}
			
			meanX = sum0 / (double)n;
			meanY = sum1 / (double)n;
			sum0 = 0.0;
			sum1 = 0.0;
			
			for (int i = 0; i < n; i++) {
				x = xValues[i];
				y = yValues[i];
				sum0 += x * y - meanX * meanY;
				sum1 += x * x - meanX * meanX;
				sum2 += (x - meanX) * (y - meanY);
				sum3 += (x - meanX) * (x - meanX);
				sum4 += (y - meanY) * (y - meanY);
			}
			
			results.Slope = sum0 / sum1;
			results.RSquare = (sum2 * sum2) / (sum3 * sum4);
			results.Intercept = meanY - results.Slope * meanX;

			return results;
		}
	}
}
