﻿/*
 * Készítette a SharpDevelop.
 * Felhasználó: phil
 * Dátum: 2009.06.11.
 * Idő: 13:37
 * 
 * A sablon megváltoztatásához használja az Eszközök | Beállítások | Kódolás | Szabvány Fejlécek Szerkesztését.
 */

using System;
using TetheredSun.Core;

namespace TetheredSun.SignalAnalysis
{
	/// <summary>
	/// Description of ChirpGenerator.
	/// </summary>
	public class ChirpGenerator : ISignalGenerator
	{
		protected IScale timeScale;
		protected IScale frequencyScale;
		protected double amplitude = 1.0;
		protected double initialPhase = 0.0;
		
		public ChirpGenerator(IScale timeScale, IScale frequencyScale, double amplitude, double initialPhase)
		{
			this.timeScale = timeScale;
			this.frequencyScale = frequencyScale;
			this.amplitude = amplitude;
			this.initialPhase = initialPhase;
		}
		
		public ChirpGenerator(IScale timeScale, IScale frequencyScale) : this(timeScale, frequencyScale, 1.0, 0.0) { }
		
		
		public IScale TimeScale {
			get { return timeScale; }
		}
		
		public IScale FrequencyScale {
			get { return frequencyScale; }
		}
		
		public double Amplitude {
			get { return amplitude; }
			set { amplitude = value; }
		}
		
		public double InitialPhase {
			get { return initialPhase; }
			set { initialPhase = value; }
		}
		
		public Signal Generate()
		{
			double[] yValues = new double[frequencyScale.Count];
			double phase = initialPhase;
			ScaleByIncrement xScale = new ScaleByIncrement(frequencyScale.Count, timeScale.Increment, timeScale.StartValue);
			Signal chirp;

			for (int i = 0; i < yValues.Length; i++) {
				yValues[i] = amplitude * Math.Sin(phase);
				phase += 2 * Math.PI * frequencyScale[i] * timeScale.Increment;
			}
			
			chirp = new Signal(xScale, yValues);
			
			return chirp;
		}
	}
}
