﻿/*
 * Készítette a SharpDevelop.
 * Felhasználó: phil
 * Dátum: 2009.06.12.
 * Idő: 8:57
 * 
 * A sablon megváltoztatásához használja az Eszközök | Beállítások | Kódolás | Szabvány Fejlécek Szerkesztését.
 */

using System;

namespace TetheredSun.SignalAnalysis
{
	
	public delegate double TimeDependentFunction(double time);
	
	/// <summary>
	/// Description of FunctionGenerator.
	/// </summary>
	public class FunctionGenerator : ISignalGenerator
	{
		protected TimeDependentFunction function;
		protected IScale timeScale;
		
		public FunctionGenerator(TimeDependentFunction function, IScale timeScale)
		{
			this.function = function;
			this.timeScale = timeScale;
		}
		
		
		public TimeDependentFunction Function {
			get { return function; }
			set { function = value; }
		}
		
		public IScale TimeScale {
			get { return timeScale; }				
		}
		
		public Signal Generate()
		{
			if (function == null) throw new NullReferenceException("Function is a null reference.");
			double[] yValues = new double[timeScale.Count];
			
			for (int i = 0; i < yValues.Length; i++) {
				yValues[i] = function(timeScale[i]);
			}
			
			return new Signal(timeScale.Clone(), yValues);
		}
		
		
	}
}
