/*
 * Created by SharpDevelop.
 * User: phil
 * Date: 2010.02.19.
 * Time: 15:15
 * 
 * To change this template use Tools | Options | Coding | Edit Standard Headers.
 */
using System;

namespace TetheredSun.SignalAnalysis
{
	/// <summary>
	/// Description of Cycle.
	/// </summary>
	public class LevelCrossingCycle
	{
		protected LevelCrossing start;
		protected LevelCrossing end;
		protected LevelCrossing next;
		
		
		public LevelCrossingCycle(LevelCrossing upCrossing, LevelCrossing downCrossing, LevelCrossing nextUpCrossing)
		{
			this.start = upCrossing;
			this.end = downCrossing;
			this.next = nextUpCrossing;
		}
		
		public LevelCrossingCycle(LevelCrossing upCrossing, LevelCrossing downCrossing) : this(upCrossing, downCrossing, null) { }
		
		public LevelCrossingCycle(LevelCrossing upCrossing) : this(upCrossing, null, null) { }
		
		public LevelCrossingCycle() : this(null, null, null) { }

		
		public LevelCrossing Start {
			get { return start; }
			set { start = value; }
		}
		
		public LevelCrossing End {
			get { return end; }
			set { end = value; }
		}
		
		public LevelCrossing Next {
			get { return next; }
			set { next = value; }
		}
		
		public double Period {
			get { return next.X - start.X; }
		}
		
		public double PulseWidth {
			get { return end.X - start.X; }
		}
		
		
		public bool Append(LevelCrossing levelCrossing)
		{
			if (start == null) {
				start = levelCrossing;
				end = null;
				next = null;
				return true;
			} else if (end == null) {
				if (start.Direction == LevelCrossingDirection.Down) {
					if (levelCrossing.Direction == LevelCrossingDirection.Up) {
						end = levelCrossing;
						next = null;
						return true;
					} else {
						return false;
					}
				} else if (start.Direction == LevelCrossingDirection.Up) {
					if (levelCrossing.Direction == LevelCrossingDirection.Down) {
						end = levelCrossing;
						next = null;
						return true;
					} else {
						return false;
					}
				} else {
					return false;
				}
			} else {
				return false;
			}
		}
	}
}
