/*
 * Created by SharpDevelop.
 * User: phil
 * Date: 2010.02.19.
 * Time: 15:58
 * 
 * To change this template use Tools | Options | Coding | Edit Standard Headers.
 */
using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
//
using TetheredSun.Core;

namespace TetheredSun.SignalAnalysis
{
	/// <summary>
	/// Description of LevelCrossingCycleCollection.
	/// </summary>
	public class LevelCrossingCycleCollection : RingBuffer<LevelCrossingCycle>
	{
		protected LevelCrossingDirection startDirection = LevelCrossingDirection.Up;
		
		public event EventHandler Updated;
		
		public LevelCrossingCycleCollection(int capacity) : base(capacity) { }
		
		
		public LevelCrossingCycleCollection() : base(DefaultCapacity) { }
		
		
		public LevelCrossingDirection StartDirection {
			get { return startDirection; }
		}
		
		public override void Add(LevelCrossingCycle item)
		{
			Add(item, true);
		}
		
		public void Add(LevelCrossingCycle item, bool raiseUpdated)
		{
			base.Add(item);
			if (this.Count > 1) {
				this[this.Count - 2].Next = item.Start;
			}
			if (raiseUpdated) OnUpdated(new EventArgs());
		}
		
		public void AddRange(IEnumerable<LevelCrossingCycle> collection)
		{
			foreach (LevelCrossingCycle item in collection) {
				this.Add(item, false);
			}
			OnUpdated(new EventArgs());
		}
		
		public void Append(LevelCrossing levelCrossing)
		{
			if (this.Count > 0) {
				if (!this[this.Count - 1].Append(levelCrossing)) {
					// The new level crossing cannot be appended to the last cycle, so it might be the start of a new cycle if it fits the pattern.
					if (levelCrossing.Direction == startDirection) {
						Add(new LevelCrossingCycle(levelCrossing));
					}
				} else {
					OnUpdated(new EventArgs());
				}
			} else {
				if (levelCrossing.Direction == startDirection) {
						Add(new LevelCrossingCycle(levelCrossing));
				}
			}
		}
		
		public void GetCrossings(double startX, out double[] upX, out double[] upY, out double[] downX, out double[] downY)
		{
			double[] empty;
			int startIndex = 0;
			int upLength;
			int downLength;
			int longer;
			int shorter;
			LevelCrossingCycle currentCycle;
			
			if (this.count < 1) {
				empty = new double[0];
				upX = empty;
				upY = empty;
				downX = empty;
				downY = empty;
				return;
			}
			
			
			
			for (int i = 0; i < this.count; i++) {
				if (this[i].Start.X >= startX) {
					startIndex = i;
					break;
				}
			}
			
			upLength = this.count - startIndex;
			downLength = upLength;
			currentCycle = this[this.count - 1];
			
			// Look at the last LevelCrossingCycle to see if it is complete.
			if (currentCycle.End == null) {
				if (currentCycle.Start == null) {
					upLength--;
					downLength--;
				} else if (currentCycle.Start.Direction == LevelCrossingDirection.Up) {
					downLength--;
				} else if (currentCycle.Start.Direction == LevelCrossingDirection.Down) {
					upLength--;
				}
			}
			
			if (upLength < 0) upLength = 0;
			if (downLength < 0) downLength = 0;
						
			upX = new double[upLength];
			upY = new double[upLength];
			downX = new double[downLength];
			downY = new double[downLength];
			
			shorter = Math.Min(upLength, downLength);
			longer = Math.Max(upLength, downLength);
			
			for (int i = 0; i < shorter; i++) {
				currentCycle = this[i + startIndex];
				if (currentCycle.Start.Direction == LevelCrossingDirection.Up) {
					upX[i] = currentCycle.Start.X;
					upY[i] = currentCycle.Start.Y;
					downX[i] = currentCycle.End.X;
					downY[i] = currentCycle.End.Y;
				} else {
					upX[i] = currentCycle.End.X;
					upY[i] = currentCycle.End.Y;
					downX[i] = currentCycle.Start.X;
					downY[i] = currentCycle.Start.Y;
				}
			}
			
			for (int i = shorter; i < longer; i++) {
				currentCycle = this[i + startIndex];
				if (currentCycle.Start.Direction == LevelCrossingDirection.Up) {
					upX[i] = currentCycle.Start.X;
					upY[i] = currentCycle.Start.Y;
				} else {
					downX[i] = currentCycle.Start.X;
					downY[i] = currentCycle.Start.Y;
				}
			}
		}
		
		protected virtual void OnUpdated(EventArgs e)
		{
			EventHandler copy = Updated;
			
			if (copy != null) {
				foreach (Delegate method in copy.GetInvocationList()) {
					ISynchronizeInvoke invoker = method.Target as ISynchronizeInvoke;
					object[] arguments = new object[] { this, e };
					if ((invoker != null) && invoker.InvokeRequired) {
						invoker.BeginInvoke(method, arguments);
					} else {
						method.DynamicInvoke(arguments);
					}
				}
			}
		}
		
	}
}
