﻿/*
 * Készítette a SharpDevelop.
 * Felhasználó: phil
 * Dátum: 2009.09.22.
 * Idő: 10:18
 * 
 * A sablon megváltoztatásához használja az Eszközök | Beállítások | Kódolás | Szabvány Fejlécek Szerkesztését.
 */
using System;
using System.Collections.Generic;

namespace TetheredSun.SignalAnalysis
{
	public enum WidthUnit {
		Absolute,
		Index
	}
	
	/// <summary>
	/// Description of MovingAverage.
	/// </summary>
	public class MovingAverage : IFilter
	{
		protected double width;
		protected WidthUnit widthUnit;
		
		
		public MovingAverage(double width, WidthUnit widthUnit)
		{
			this.width = width;
			this.widthUnit = widthUnit;
		}
		
		public MovingAverage(double width) : this(width, WidthUnit.Absolute) { }
		
		public MovingAverage() : this(1.0, WidthUnit.Absolute) { }
		
		
		
		public double Width {
			get { return width; }
			set { width = value; }
		}
		
		public WidthUnit WidthUnit {
			get { return widthUnit; }
			set { widthUnit = value; }
		}
		
		
		
		public Signal Filter(Signal original)
		{
			Signal filtered = new Signal(original.XScale.Clone(), new double[original.YValues.Count]);
			int widthInIndices = (widthUnit == WidthUnit.Absolute) ?
				(int)Math.Round(width / original.XScale.Increment, MidpointRounding.AwayFromZero) :
				(int)width;
			
			for (int i = 0; i < filtered.YValues.Count; i++) {
				filtered[i] = GetLocalAverage(original.YValues, i, widthInIndices);
			}
			
			return filtered;
		}
		
		protected double GetLocalAverage(IList<double> list, int index, int widthInIndices)
		{
			int minIndex = index - widthInIndices;
			int maxIndex = index + widthInIndices;
			int count = 0;
			double sum = 0.0;
			
			if (minIndex < 0) minIndex = 0;
			if (maxIndex >= list.Count) maxIndex = list.Count - 1;
			
			for (int i = minIndex; i <= maxIndex; i++) {
				sum += list[i];
				count++;
			}
			
			return sum / count;
		}
	}
}
