﻿/*
 * Készítette a SharpDevelop.
 * Felhasználó: phil
 * Dátum: 2009.09.03.
 * Idő: 13:49
 * 
 * A sablon megváltoztatásához használja az Eszközök | Beállítások | Kódolás | Szabvány Fejlécek Szerkesztését.
 */
using System;

namespace TetheredSun.SignalAnalysis
{
	/// <summary>
	/// Description of PeriodicRandomNoiseGenerator.
	/// </summary>
	public class PeriodicRandomNoiseGenerator : ISignalGenerator
	{
		protected IScale timeScale;
		protected IScale frequencyScale;
		protected int? seed;
		protected Random random;
		
		
		public PeriodicRandomNoiseGenerator(IScale timeScale, IScale frequencyScale, Nullable<int> seed)
		{
			this.timeScale = timeScale;
			this.frequencyScale = frequencyScale;
			this.seed = seed;
			random = seed.HasValue ? new Random(seed.Value) : new Random();
		}
		
		public PeriodicRandomNoiseGenerator(IScale timeScale, IScale frequencyScale) :this (timeScale, frequencyScale, null) { }
		
		
		public IScale FrequencyScale {
			get { return frequencyScale; }
		}
		
		public IScale TimeScale {
			get { return timeScale; }
		}
		
		public Signal Generate()
		{
			if (timeScale == null) throw new InvalidOperationException("Cannot generate signal: time scale is null.");
			if (frequencyScale == null) throw new InvalidOperationException("Cannot generate signal: frequency scale is null.");
			
			double sum;
			double piDoubled = 2.0 * Math.PI;
			Signal signal = new Signal(timeScale, new double[timeScale.Count]);
			
			for (int i = 0; i < timeScale.Count; i++) {
				sum = 0.0;
				
				for (int j = 0; j < frequencyScale.Count; j++) {
					sum += Math.Sin(piDoubled * frequencyScale[j] * timeScale[i] + piDoubled * random.NextDouble());
				}
				
				signal[i] = sum;
			}
			
			return signal;
		}
		
		
		
	}
}
