﻿/*
 * Készítette a SharpDevelop.
 * Felhasználó: phil
 * Dátum: 2009.09.03.
 * Idő: 12:13
 * 
 * A sablon megváltoztatásához használja az Eszközök | Beállítások | Kódolás | Szabvány Fejlécek Szerkesztését.
 */
using System;

namespace TetheredSun.SignalAnalysis
{
	/// <summary>
	/// Description of UniformNoiseGenerator.
	/// </summary>
	public class UniformNoiseGenerator : ISignalGenerator
	{
		protected IScale timeScale;
		protected Random random;
		protected int? seed;
		
		
		public UniformNoiseGenerator(IScale timeScale, Nullable<int> seed)
		{
			this.timeScale = timeScale;
			this.seed = seed;
			this.random = seed.HasValue ? new Random(seed.Value) : new Random();
		}
		
		public UniformNoiseGenerator(IScale timeScale) : this(timeScale, null) { }
		
		
		public IScale TimeScale {
			get { return timeScale; }
		}
		
		public Signal Generate()
		{
			if (timeScale == null) throw new InvalidOperationException("Cannot generate signal: time scale is null.");
			Signal signal = new Signal(timeScale, new double[timeScale.Count]);
			
			for (int i = 0; i < signal.YValues.Count; i++) {
				signal[i] = random.NextDouble();
			}
			
			return signal;
		}
		
	}
}
