function [Poses] = Cayley_Mini_solver(input,camNum,generator)

%generator='kneip';
% generator is the solver type zuzana or kneip
%  'zuzana' referes to the solver based on Matlab (check the paper)
%  'kneip' referes to the solver based on c++ (check the paper)
% ------------------------------------------------------------------


% NORMALISATION of the 3D data into the cubic unit around the origin of
% the world frame
% Calculation of the normals and the unite direction of the 3D lines
% ------------------------------------------------------------------
lineNum = ones(1,camNum)*3;
D = generateDataAbs( input,lineNum);


% calling the solver with D: input structure contains the normals and
% the unit direction vectors
% generator (zuzana or kneip)
% ------------------------------------------------------------------

[R_selectedabs,T_selectedabs,number] = Solver_for_Rotation_min(D,generator);
numberofSolutions(1) = number;

if isnan(R_selectedabs)
    warning('No solution can be found! please check your data.');
    Poses = nan;
    return
end


% Denormalisation of the pose into the original world coordinate sysetm
% ------------------------------------------------------------------
Denorm_pose = [R_selectedabs T_selectedabs; 0 0 0 1]*  (D.N3);
Denorm_pose1=Denorm_pose/norm(Denorm_pose(1:3,1:3));


R{1} = Denorm_pose1(1:3,1:3);
T{1} = Denorm_pose1(1:3,4);


%%
for cam=2:camNum
    
    
    % Transforming the data with the absolute pose: [R_selectedabs T_selectedabs; 0 0 0 1]
    % NORMALISATION of the 3D data into the cubic unit around the origin of
    % the world frame
    % Calculation of the normals and the unite direction of the 3D lines
    % ------------------------------------------------------------------
       
    D = generateDataRel( input,lineNum,cam,R_selectedabs,T_selectedabs);
    
    % calling the direct solver for the reference camera to estimates the
    % relative pose
    % ------------------------------------------------------------------
    
    [R_selected,T_selected,number] = Solver_for_Rotation_min(D,generator);
    numberofSolutions(cam) = number;
    
    if isnan(R_selected)
        continue;
    end
    
    % Denormalisation of the pose into the original world coordinate sysetm
    % ------------------------------------------------------------------
    
    poseabs = [R_selectedabs T_selectedabs; 0 0 0 1]*  (D.N3);
    poseabs_norm = poseabs/norm(poseabs(1:3,1:3));
    
    fullpose = [R_selected T_selected; 0 0 0 1] *poseabs ;
    fullpose = fullpose/norm(fullpose(1:3,1:3));
    
    Denorm_pose1 = fullpose * inv(poseabs_norm);
    
    R{cam} = Denorm_pose1(1:3,1:3);
    T{cam} = Denorm_pose1(1:3,4)/norm(poseabs(1:3,1:3));
    
    
end

for y=1:camNum

    
    Poses{y} = [R{y} T{y} ; 0 0 0 1];
    [R{y} T{y} ; 0 0 0 1];
end

end