function [Poses] = Cayley_Mini_solver_all(input,generator)


% ------------------------------------------------------------------


% NORMALISATION of the 3D data into the cubic unit around the origin of
% the world frame
% Calculation of the normals and the unite direction of the 3D lines
% ------------------------------------------------------------------
lineNum = 3;
D = generateDataAbs( input,lineNum);


% calling the solver with D: input structure contains the normals and
% the unit direction vectors
% generator (zuzana or kneip)
% ------------------------------------------------------------------

[Poses_o] = Solver_for_Rotation_min_all(D,generator);


    if isempty(Poses_o)
        warning('no solution found, please check the input')
        Poses = nan;
        return
    end


% Denormalisation of the pose into the original world coordinate sysetm
% ------------------------------------------------------------------

    
    
    for k=1:length(Poses_o)
        
        Denorm_pose = [Poses_o{k}(1:3,1:3) Poses_o{k}(1:3,4); 0 0 0 1]*  (D.N3);
        Denorm_pose1=Denorm_pose/norm(Denorm_pose(1:3,1:3));
        Poses{k} = [Denorm_pose1(1:3,1:3) Denorm_pose1(1:3,4); 0 0 0 1] ;
        
    end


%%
