function [Poses,inlierIdx_all, bp_error, pose_estimated_all, line_error_all,...
    line_error_all_lines, imaginary] = Cayley_RANSAC(input,lineNum,camNum,generator,maxDistance)

% bp_error: backprojection error in pixels
% pose_estimated_all: all possible solutions
% line_error_all: backprojection error used for choosing best pose
% line_error_all_line: backprojection error of all lines for all poses
% imaginary: imaginary part of roots that were cut off


bp_error = nan(1,lineNum(1));
pose_estimated_all = nan;

% ------------------------------------------------------------------

D = generateDataAbs( input,lineNum);

[inlierIdx, ArrayData]= Ransac_main(D,maxDistance,generator);

inlierIdx_all{1} = inlierIdx;
% NORMALISATION of the 3D data into the cubic unit around the origin of
% the world frame
% Calculation of the normals and the unite direction of the 3D lines
% ------------------------------------------------------------------

D = generateDataAbs_Ransac( input,inlierIdx);

% calling the solver with D: input structure contains the normals and
% the unit direction vectors
% generator (zuzana or kneip)
% ------------------------------------------------------------------
[R_selectedabs,T_selectedabs,number, ~,~,~, pose_estimated_all,...
    line_error_all, line_error_all_lines, imaginary] = Solver_for_Rotation(D,generator);
numberofSolutions(1) = number;




%%VV %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if iscell(pose_estimated_all)
    for jj = 1:size(pose_estimated_all,2)
        Denorm_pose = pose_estimated_all{jj} * (D.N3);
        Denorm_pose1=Denorm_pose/norm(Denorm_pose(1:3,1:3));
        
        Rtmp = Denorm_pose1(1:3,1:3);
        Ttmp = Denorm_pose1(1:3,4);
        pose_estimated_all{jj} = [Rtmp Ttmp; 0 0 0 1];
    end
end






%%VV %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if isnan(R_selectedabs)
    %     warning('No solution can be found! please check your data.');
    Poses{1} = nan;
    return
end

% Denormalisation of the pose into the original world coordinate sysetm
% ------------------------------------------------------------------
Denorm_pose = [R_selectedabs T_selectedabs; 0 0 0 1]*  (D.N3);
Denorm_pose1=Denorm_pose/norm(Denorm_pose(1:3,1:3));


R{1} = Denorm_pose1(1:3,1:3);
T{1} = Denorm_pose1(1:3,4);


% process the other camera if any!
% same steps are done for the other cameras when >= 2
% ------------------------------------------------------------------

for cam=2:camNum
    
    
    D = generateDataRel( input,lineNum,cam,R_selectedabs,T_selectedabs);
    
    [inlierIdx] = Ransac_main(D,maxDistance,generator);
    inlierIdx_all{cam} = inlierIdx;
    
    
    % Transforming the data with the absolute pose: [R_selectedabs T_selectedabs; 0 0 0 1]
    % NORMALISATION of the 3D data into the cubic unit around the origin of
    % the world frame
    % Calculation of the normals and the unite direction of the 3D lines
    % ------------------------------------------------------------------
    
    D = generateDataRel_Ransac( input,inlierIdx,cam,R_selectedabs,T_selectedabs);
    
    
    
    
    % calling the direct solver for the reference camera to estimates the
    % relative pose
    % ------------------------------------------------------------------
    
    [R_selected,T_selected,number] = Solver_for_Rotation(D,generator);
    numberofSolutions(cam) = number;
    
    if isnan(R_selected)
        R{cam} = [];
        continue;
    end
    
    % Denormalisation of the pose into the original world coordinate sysetm
    % ------------------------------------------------------------------
    
    
    poseabs = [R_selectedabs T_selectedabs; 0 0 0 1]*  (D.N3);
    poseabs_norm = poseabs/norm(poseabs(1:3,1:3));
    
    fullpose = [R_selected T_selected; 0 0 0 1] *poseabs ;
    fullpose = fullpose/norm(fullpose(1:3,1:3));
    
    Denorm_pose1 = fullpose * inv(poseabs_norm);
    
    R{cam} = Denorm_pose1(1:3,1:3);
    T{cam} = Denorm_pose1(1:3,4)/norm(poseabs(1:3,1:3));
    
    
end

%% formating the denormalised rsults into R_selected (for the
% rotation) and T_selected (for the translation)
% ------------------------------------

for y=1:camNum
    
    if ~isempty(R{y})
        
        Poses{y} = [R{y} T{y} ; 0 0 0 1];
        [R{y} T{y} ; 0 0 0 1];
        
    else
        
        Poses{y}= nan;
        
    end
    
    
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
pose_estimated = Poses{1};
distFcn = @(pose_estimated,ArrayData)...
    Back_projection_error_new_fast(pose_estimated,ArrayData(:,1),ArrayData(:,2),ArrayData(:,3),...
    ArrayData(:,4),ArrayData(:,5),ArrayData(:,6),...
    ArrayData(:,7),ArrayData(:,8),ArrayData(:,9),...
    ArrayData(:,10),ArrayData(:,11),ArrayData(:,12),...
    ArrayData(:,13),ArrayData(:,14),ArrayData(:,15),D.cameraType);

bp_error = distFcn(Poses{1}, ArrayData);



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%





end