function [line_error] = Back_projection_error_new_fast(pose_estimated,p1_sx,p1_sy,p1_sz,...
    p1_ex,p1_ey,p1_ez,...
    p1w_sx,p1w_sy,p1w_sz,...
    p1w_ex,p1w_ey,p1w_ez,...
    vx,vy,vz,...
    cameraType)


if ~isnan(pose_estimated)
    
    
    lines_3D_V= [vx,vy,vz];
    
    
    lines_2D_start = [p1_sx p1_sy p1_sz] ;
    lines_2D_end= [p1_ex p1_ey p1_ez] ;
    lines_3D_start= [p1w_sx,p1w_sy,p1w_sz, ones(size(p1w_sx,1),1) ];
    lines_3D_end= [p1w_ex,p1w_ey,p1w_ez, ones(size(p1w_ex,1),1)];
    
    
    
    lines_3D_start_A =( pose_estimated * lines_3D_start')';
    lines_3D_start_B = lines_3D_start_A(:,1:3)./lines_3D_start_A(:,4);
    
    lines_3D_end_A =( pose_estimated * lines_3D_end')';
    lines_3D_end_B = lines_3D_end_A(:,1:3)./lines_3D_end_A(:,4);
    
    lines_3D_start_C = lines_3D_start_B(:,1:3)./lines_3D_start_B(:,3);
    lines_3D_end_C = lines_3D_end_B(:,1:3)./lines_3D_end_B(:,3);
    
    if strcmp( 'OmniAbs',cameraType )  || strcmp( 'Omni',cameraType )
        
        
        lines_3D_start_C = lines_3D_start_C(:,1:3)./(vecnorm(lines_3D_start_C')');
        lines_3D_end_C = lines_3D_end_C(:,1:3)./(vecnorm(lines_3D_end_C')');
        
    else
        
        lines_2D_start = lines_2D_start(:,1:3)./(vecnorm(lines_2D_start')');
        lines_2D_end = lines_2D_end(:,1:3)./(vecnorm(lines_2D_end')');
        
    end
    
    
    x1 = lines_2D_start(:,1);
    y1 = lines_2D_start(:,2);
    z1 = lines_2D_start(:,3);
    
    x2 = lines_2D_end(:,1);
    y2 = lines_2D_end(:,2);
    z2 = lines_2D_end(:,3);
    
    x3 = lines_3D_start_C(:,1);
    y3 = lines_3D_start_C(:,2);
    z3 = lines_3D_start_C(:,3);
    
    x4 = lines_3D_end_C(:,1);
    y4 = lines_3D_end_C(:,2);
    z4 = lines_3D_end_C(:,3);
    
    ort_length2 = orthodromic_length_vec([x1, y1,z1], [x2, y2,z2]);
    short_orth_distA2 = shortest_orthodromic_distance_vec([x1, y1,z1],[x3, y3,z3],[x4, y4,z4]);
    short_orth_distB2 = shortest_orthodromic_distance_vec([x2, y2,z2],[x3, y3,z3],[x4, y4,z4]);
    
    line_error = (short_orth_distA2.*short_orth_distA2 +short_orth_distB2.*short_orth_distB2)./ort_length2 ;
    
    
    
else
    
    line_error(1:size(p1_sx,1))=1000;
end


end
