function [line_error] = Error_measurement_return(D)


ArrayData (:,1) = D.p1(1,:)';
ArrayData (:,2) = D.p1(2,:)';
ArrayData (:,3) = D.p1(3,:)';

ArrayData (:,4) = D.p2(1,:)';
ArrayData (:,5) = D.p2(2,:)';
ArrayData (:,6) = D.p2(3,:)';

ArrayData (:,7) = D.P1_w(1,:)';
ArrayData (:,8) = D.P1_w(2,:)';
ArrayData (:,9) = D.P1_w(3,:)';

ArrayData (:,10) = D.P2_w(1,:)';
ArrayData (:,11) = D.P2_w(2,:)';
ArrayData (:,12) = D.P2_w(3,:)';



pose_estimated = [D.R D.T; 0 0 0 1];

if ~isnan(pose_estimated)
    

%     lines_3D_V= [ArrayData(:,13) ArrayData(:,15) ArrayData(:,15)];
    
    
    lines_2D_start = [ArrayData(:,1) ArrayData(:,2) ArrayData(:,3)] ;
    lines_2D_end= [ArrayData(:,4) ArrayData(:,5) ArrayData(:,6)] ;
    lines_3D_start= [ArrayData(:,7) ArrayData(:,8) ArrayData(:,9), ones(size(ArrayData(:,7),1),1) ];
    lines_3D_end= [ArrayData(:,10) ArrayData(:,11) ArrayData(:,12), ones(size(ArrayData(:,7),1),1)];

    
    

    lines_3D_start_A =( pose_estimated * lines_3D_start')';
    lines_3D_start_B = lines_3D_start_A(:,1:3)./lines_3D_start_A(:,4);
    
    lines_3D_end_A =( pose_estimated * lines_3D_end')';
    lines_3D_end_B = lines_3D_end_A(:,1:3)./lines_3D_end_A(:,4);
    
    lines_3D_start_C = lines_3D_start_B(:,1:3)./lines_3D_start_B(:,3);        
    lines_3D_end_C = lines_3D_end_B(:,1:3)./lines_3D_end_B(:,3);     

    % Robi
    lines_3D_start_Sph1 =( pose_estimated * lines_3D_start')';
    lines_3D_start_Sph = lines_3D_start_Sph1(:,1:3) ./(vecnorm(lines_3D_start_Sph1(:,1:3)')');
    lines_3D_end_Sph1 =( pose_estimated * lines_3D_end')';
    lines_3D_end_Sph = lines_3D_end_Sph1(:,1:3) ./(vecnorm(lines_3D_end_Sph1(:,1:3)')');
%     
% figure;
% plot3(lines_3D_start_Sph1(:,1),lines_3D_start_Sph1(:,2),lines_3D_start_Sph1(:,3)); hold on;
% plot3(0,0,0, 'rx');

    
    if strcmp( 'OmniAbs',D.cameraType )  || strcmp( 'Omni',D.cameraType )
        
        
        lines_3D_start_C = lines_3D_start_C(:,1:3)./(vecnorm(lines_3D_start_C')');
        lines_3D_end_C = lines_3D_end_C(:,1:3)./(vecnorm(lines_3D_end_C')');       
        
    else
        
        lines_3D_start_C = lines_3D_start_C(:,1:3)./(vecnorm(lines_3D_start_C')');
        lines_3D_end_C = lines_3D_end_C(:,1:3)./(vecnorm(lines_3D_end_C')');        
        
        lines_2D_start = lines_2D_start(:,1:3)./(vecnorm(lines_2D_start')');
        lines_2D_end = lines_2D_end(:,1:3)./(vecnorm(lines_2D_end')');      
    
        
    end
    
  % Robi  
%    lines_3D_start_C = lines_3D_start_Sph;
%    lines_3D_end_C = lines_3D_end_Sph;
   
   for k=1:size(ArrayData,1)
        
        x1 = lines_2D_start(k,1);
        y1 = lines_2D_start(k,2);
        z1 = lines_2D_start(k,3);    
        
        x2 = lines_2D_end(k,1);
        y2 = lines_2D_end(k,2);
        z2 = lines_2D_end(k,3);
        
        x3 = lines_3D_start_C(k,1);
        y3 = lines_3D_start_C(k,2);
        z3 = lines_3D_start_C(k,3);
        
        x4 = lines_3D_end_C(k,1);
        y4 = lines_3D_end_C(k,2);
        z4 = lines_3D_end_C(k,3);
        
        
        

        ort_length = orthodromic_length([x1, y1,z1], [x2, y2,z2]);
%         ort_length_k(k) = ort_length;        
        short_orth_distA = shortest_orthodromic_distance([x1, y1,z1],[x3, y3,z3],[x4, y4,z4]);
        short_orth_distB = shortest_orthodromic_distance([x2, y2,z2],[x3, y3,z3],[x4, y4,z4]);
        
%         line_error(k) = ort_length*((short_orth_distA*short_orth_distA)+(short_orth_distB*short_orth_distB)) ;
        line_error(k) = (short_orth_distA^2+short_orth_distB^2)/ort_length ;
        
        
%                            figure,
%                         hold on
%                         scatter3(0,0,0)
%                         scatter3(x1,y1,z1,'MarkerFaceColor',[0 0 1]) % Blue ()
%                         scatter3(x2,y2,z2,'MarkerFaceColor',[0 0 1]) % Blue ()
%                         scatter3(x3,y3,z3,'MarkerFaceColor',[1 0 0])% Red
%                         scatter3(x4,y4,z4,'MarkerFaceColor',[1 0 0])% Red
%                     
%                     [x,y,z] = sphere(30);
%                     s1 = surf(x,y,z);
%                     shading faceted
%                     hold on
%                     axis equal
%                     camlight
%                     lighting gouraud
%                     set(s1,'facecolor',[.98 .45 .02]);        
        
        
% ort_length*
   end
   
   
%            line_error =  line_error / sum(ort_length_k);
%            line_error =  line_error;

%     
else

    
    line_error(1:size(ArrayData,1))=1000;
end



end
    
