function [inlierIdx, ArrayData] = Ransac_main(D,maxDistance,generator)


ArrayData (:,1) = D.p1(1,:)';
ArrayData (:,2) = D.p1(2,:)';
ArrayData (:,3) = D.p1(3,:)';

ArrayData (:,4) = D.p2(1,:)';
ArrayData (:,5) = D.p2(2,:)';
ArrayData (:,6) = D.p2(3,:)';

ArrayData (:,7) = D.P1_w(1,:)';
ArrayData (:,8) = D.P1_w(2,:)';
ArrayData (:,9) = D.P1_w(3,:)';

ArrayData (:,10) = D.P2_w(1,:)';
ArrayData (:,11) = D.P2_w(2,:)';
ArrayData (:,12) = D.P2_w(3,:)';

ArrayData (:,13) = D.Directions(1,:)';
ArrayData (:,14) = D.Directions(2,:)';
ArrayData (:,15) = D.Directions(3,:)';

ArrayData (:,16) = D.normals(1,:)';
ArrayData (:,17) = D.normals(2,:)';
ArrayData (:,18) = D.normals(3,:)';


fitFcn = @(ArrayData) ... 
    Solver_for_Rotation_min_Ransac(ArrayData(:,13),ArrayData(:,14),ArrayData(:,15),...
    ArrayData(:,16),ArrayData(:,17),ArrayData(:,18),...
    ArrayData (:,1),ArrayData (:,2),ArrayData (:,3),...,
    ArrayData (:,4),ArrayData (:,5),ArrayData (:,6),...    
    ArrayData (:,7),ArrayData (:,8),ArrayData (:,9),...,
    ArrayData (:,10),ArrayData (:,11),ArrayData (:,12),...
    generator,D);    
     %Solver_for_Rotation_min_Ransac(D,generator);

distFcn = @(pose_estimated,ArrayData)...
    Back_projection_error_new_fast(pose_estimated,ArrayData(:,1),ArrayData(:,2),ArrayData(:,3),...
    ArrayData(:,4),ArrayData(:,5),ArrayData(:,6),...
    ArrayData(:,7),ArrayData(:,8),ArrayData(:,9),...
    ArrayData(:,10),ArrayData(:,11),ArrayData(:,12),...
    ArrayData(:,13),ArrayData(:,14),ArrayData(:,15),D.cameraType);



sampleSize =3;


% [~,inlierIdx] = ransac(ArrayData,fitFcn,distFcn,sampleSize,maxDistance,'MaxNumTrials',100000,'Confidence',99.999999);
  [~,inlierIdx] = ransac(ArrayData,fitFcn,distFcn,sampleSize,maxDistance,'MaxNumTrials',100000,'Confidence',99.999999);
    
  
%   original ransac copy, no modification
%   addpath ransac
%   [~,inlierIdx] = ransac_2(ArrayData,fitFcn,distFcn,sampleSize,maxDistance,'MaxNumTrials',100000,'Confidence',99.999999, 'MaxSamplingAttempts', 1000);
  
 
  
  
 %{
 %% %%%%%%%%%%%%%%%% VV ROSSZ*************************************************************
  pose_estimated = fitFcn(ArrayData(inlierIdx,:));
  bp_error = distFcn(pose_estimated, ArrayData(inlierIdx,:));
  
%  pose_outliers = fitFcn(ArrayData(~inlierIdx,:));
%  bp_error_outliers = distFcn(pose_outliers, ArrayData(~inlierIdx,:));
  
 
 
    

    
    lines_2D_start = [ArrayData(:,1),ArrayData(:,2),ArrayData(:,3)];
    lines_2D_end = [ArrayData(:,4),ArrayData(:,5),ArrayData(:,6)];
        
    
    lines_3D_start= [ArrayData(:,7),ArrayData(:,8),ArrayData(:,9), ones(size(ArrayData(:,7),1),1) ];
    lines_3D_end= [ArrayData(:,10),ArrayData(:,11),ArrayData(:,12), ones(size(ArrayData(:,10),1),1)];
    
    
    
    
    
    lines_3D_start_A =( pose_estimated * lines_3D_start')';
    lines_3D_start_B = lines_3D_start_A(:,1:3)./lines_3D_start_A(:,4);
    
    lines_3D_end_A =( pose_estimated * lines_3D_end')';
    lines_3D_end_B = lines_3D_end_A(:,1:3)./lines_3D_end_A(:,4);
    
    lines_3D_start_C = lines_3D_start_B(:,1:3)./lines_3D_start_B(:,3);
    lines_3D_end_C = lines_3D_end_B(:,1:3)./lines_3D_end_B(:,3);
    
    
    
     lines_2D_start = lines_2D_start(:,1:3)./(vecnorm(lines_2D_start')');
     lines_2D_end = lines_2D_end(:,1:3)./(vecnorm(lines_2D_end')');    
 
    x1 = lines_2D_start(:,1);
    y1 = lines_2D_start(:,2);
    z1 = lines_2D_start(:,3);
    
    x2 = lines_2D_end(:,1);
    y2 = lines_2D_end(:,2);
    z2 = lines_2D_end(:,3);
    
    x3 = lines_3D_start_C(:,1);
    y3 = lines_3D_start_C(:,2);
    z3 = lines_3D_start_C(:,3);
    
    x4 = lines_3D_end_C(:,1);
    y4 = lines_3D_end_C(:,2);
    z4 = lines_3D_end_C(:,3);
    
    ort_length2 = orthodromic_length_vec([x1, y1,z1], [x2, y2,z2]);
    short_orth_distA2 = shortest_orthodromic_distance_vec([x1, y1,z1],[x3, y3,z3],[x4, y4,z4]);
    short_orth_distB2 = shortest_orthodromic_distance_vec([x2, y2,z2],[x3, y3,z3],[x4, y4,z4]);
    
    line_error = (short_orth_distA2.*short_orth_distA2 +short_orth_distB2.*short_orth_distB2)./ort_length2 ;
  
  
    
    lines_2D_start = [ArrayData(:,1),ArrayData(:,2),ArrayData(:,3)];
    lines_2D_end = [ArrayData(:,4),ArrayData(:,5),ArrayData(:,6)];
        
    
    lines_3D_start= [ArrayData(:,7),ArrayData(:,8),ArrayData(:,9), ones(size(ArrayData(:,7),1),1) ];
    lines_3D_end= [ArrayData(:,10),ArrayData(:,11),ArrayData(:,12), ones(size(ArrayData(:,10),1),1)];
    
    
    % BP ERROR WITH GROUND TRUTH POSE
    
    
    lines_3D_start_A =( predicted_pose * lines_3D_start')';
    lines_3D_start_B = lines_3D_start_A(:,1:3)./lines_3D_start_A(:,4);
    
    lines_3D_end_A =( predicted_pose * lines_3D_end')';
    lines_3D_end_B = lines_3D_end_A(:,1:3)./lines_3D_end_A(:,4);
    
    lines_3D_start_C = lines_3D_start_B(:,1:3)./lines_3D_start_B(:,3);
    lines_3D_end_C = lines_3D_end_B(:,1:3)./lines_3D_end_B(:,3);
    
    
    
     lines_2D_start = lines_2D_start(:,1:3)./(vecnorm(lines_2D_start')');
     lines_2D_end = lines_2D_end(:,1:3)./(vecnorm(lines_2D_end')');    
 
    x1 = lines_2D_start(:,1);
    y1 = lines_2D_start(:,2);
    z1 = lines_2D_start(:,3);
    
    x2 = lines_2D_end(:,1);
    y2 = lines_2D_end(:,2);
    z2 = lines_2D_end(:,3);
    
    x3 = lines_3D_start_C(:,1);
    y3 = lines_3D_start_C(:,2);
    z3 = lines_3D_start_C(:,3);
    
    x4 = lines_3D_end_C(:,1);
    y4 = lines_3D_end_C(:,2);
    z4 = lines_3D_end_C(:,3);
    
    ort_length2 = orthodromic_length_vec([x1, y1,z1], [x2, y2,z2]);
    short_orth_distA2 = shortest_orthodromic_distance_vec([x1, y1,z1],[x3, y3,z3],[x4, y4,z4]);
    short_orth_distB2 = shortest_orthodromic_distance_vec([x2, y2,z2],[x3, y3,z3],[x4, y4,z4]);
    
    gt_error = (short_orth_distA2.*short_orth_distA2 +short_orth_distB2.*short_orth_distB2)./ort_length2 ;
  
  %}
  
  
  
  
  
  
  
end

