function Data = generateDataAbs_Ransac( input,inlierIdx)

% Kc = [1587.10563570372,0,780.247922780691;0,1586.61861234545,1190.84797885549;0,0,1];

p1 = input.Camera(1).Line(:).start(inlierIdx,:)';
p2 = input.Camera(1).Line(:).end(inlierIdx,:)';

% p1 = p1(:,1:nline);
% p2 = p2(:,1:nline);


% Rotation matrix from  world to cam frame R
%R = input.Camera(1).R;
% translation from world to cam frame T
%T = input.Camera(1).t;


P1_w = input.line3D(1).start(inlierIdx,:)';
P2_w = input.line3D(1).end(inlierIdx,:)';

% P1_w = P1_w(:,1:nline);
% P2_w = P2_w(:,1:nline);


P3D = [P1_w,P2_w]';

[normalised_3D_points, N3] = preproc_3D( P3D );


P1_w = normalised_3D_points(:,1:size(P1_w,2));
P2_w = normalised_3D_points(:,size(P1_w,2)+1:end);

P1_w_original=P1_w;
P2_w_original=P2_w;

Vww=P2_w-P1_w;
Directions_original = Vww ./ vecnorm(Vww);

cameraType = input.Camera(1).type;


if strcmp( 'PerspAbs',cameraType ) || strcmp( 'Persp',cameraType )

    Vww=P2_w-P1_w;
    Directions = Vww ./ vecnorm(Vww);
    
    
    Vww2D=p2-p1;
    Directions2D = Vww2D ./ vecnorm(Vww2D);
    normals=(cross(Directions2D,p1)) ./vecnorm(cross(Directions2D,p1));
    
elseif strcmp( 'OmniAbs',cameraType )  || strcmp( 'Omni',cameraType )
    Vww=P2_w-P1_w;
    Directions = Vww ./ vecnorm(Vww);
    
    normals=(cross(p1,p2)) ./vecnorm(cross(p1,p2));
    
end



Data.P1_w_original=P1_w_original;
Data.P2_w_original=P2_w_original;
Data.p1 = p1;
Data.p2 = p2;
Data.P1_w = P1_w;
Data.P2_w = P2_w;
%Data.R = R;
%Data.T = T;
%Data.R_cw = R;
%Data.T_cw= T;
Data.Directions = Directions;
Data.Directions_original = Directions_original;

Data.normals = normals;
% Data.Kc = Kc;
Data.cameraType = cameraType;
Data.N3 = N3;


end

