function [Rx, Ry, Rz,angleX ,angleY ,angleZ] = rotAnglefromMatrix2 (Rrelm)

% given in RIGHT handed coordinate system, check rotMfromAngle2 for more
% details
% http://planning.cs.uiuc.edu/node102.html
% http://planning.cs.uiuc.edu/node103.html
% this will decompose a rotatin matrix composed by the rotations RzRyRx,
% that is the order of rotations was about the axis x, then y, then z

angleX = atan2(Rrelm(3,2), Rrelm(3,3));
angleY = atan2(-Rrelm(3,1), sqrt(Rrelm(3,2)^2 + Rrelm(3,3)^2) );
angleZ = atan2(Rrelm(2,1), Rrelm(1,1));


Rx = [ 1 0 0 ; 0 cos(angleX) -sin(angleX); 0 sin(angleX) cos(angleX)];
Ry = [ cos(angleY) 0 sin(angleY) ; 0 1 0; -sin(angleY) 0 cos(angleY)];
Rz = [ cos(angleZ) -sin(angleZ) 0 ; sin(angleZ) cos(angleZ) 0; 0 0 1];


end
