function [angleX, angleY, angleZ] = rotAnglefromMatrix2ds (Rrelm)

% given in RIGHT handed coordinate system, check rotMfromAngle2 for more
% details
% http://planning.cs.uiuc.edu/node102.html
% http://planning.cs.uiuc.edu/node103.html
% this will decompose a rotatin matrix composed by the rotations RzRyRx,
% that is the order of rotations was about the axis x, then y, then z

angleX = tan((atan2(Rrelm(3,2), Rrelm(3,3)))/2);
angleY = tan((atan2(-Rrelm(3,1), sqrt(Rrelm(3,2)^2 + Rrelm(3,3)^2) ))/2);
angleZ = tan((atan2(Rrelm(2,1), Rrelm(1,1)))/2);





end
