% published: 2019-12-05,
% Updated: 2021-09-30, Thanks to Viktor Vilagos, return real part of
% the complex solution and updated the code

% Authors: Hichem Abdellali, Robert Frohlich, Zoltan Kato  using Matlab (R2018b)
% All rights reserved.

% Important!
% ------------------------------------------------------------------------
% Please cite our [1] publication whenever you use the implementation.


% Introduction
% ------------------------------------------------------------------------

% This software package contains the full algorithm as described in paper [1].

% [1]: Hichem Abdellali, Robert Frohlich, Zoltan Kato; Robust Absolute and 
% Relative Pose Estimation of a Central Camera System from 2D-3D Line
% Correspondences, IEEE, ICCV, 2019

% Installation
% ------------------------------------------------------------------------

% This package does not require any installation. Package contains all
% necessary functions. the solver needs endpoints from 2D-3D line
% coorespandances (an example is provided),

% ------------------------------------------------------------------------
% -------------------------------- NOTE ----------------------------------
% ------------------------------------------------------------------------

% the algorithm expects normalized coordinates on the unit 
% sphere. If our camera is a calibrated perspective camera and we have a 
% 2D homogenous coordinate 'x' then using K:
% temp = inv(K) * x;
% x_sphere = temp ./ norm(temp);


% ------------------------------------------------------------------------
% ---------------------------- Main input --------------------------------
% ------------------------------------------------------------------------
%input.Camera(i).Line.start = normalized coordinates on the unit sphere of the image line segment startpoints.
%input.Camera(i).Line.end = normalized coordinates on the unit sphere of the image line segment endpoints.
%input.line3D.start = start points of the 3D line segments in world coordinates.
%input.line3D.end = end points of the 3D line segments in world coordinates.
% camera type : 
%               --> 'PerspAbs' or 'Persp'  for perspective camera
%               --> 'Omni' or 'OmniAbs' for Omnidirectional camera

% please check the input.mat 


% ------------------------------------------------------------------------
% -------------------------additional input ------------------------------
% ------------------------------------------------------------------------
% type: referring to the solver generator used in [1] to generate the
% solver it can be 
% 1 : it is a calling the solver generated with the matlab based
% solver generator from kukelova 
% 2 : it is a calling the solver generated with the c++ solver generator from Kneip( we used mex to be able to run it from matlab)
% camNum: number of camera. 
% lineNum : number of 2D-3D line pairs to be used.


% ------------------------------------------------------------------------
% ----------------------------- output -----------------------------------
% ------------------------------------------------------------------------
% poses : a cell which contains a list of poses of 4*4 matrix
% poses{1} acts from the world coordinate system to the reference camera ('Absolute pose').
% poses{2:camNum} acts from the reference camera to the other cameras ('Relative Poses').
% Note that the output poses are already denormalized to the original world
% coordinate system.


% Note we filter out the bas solution using the backprojection error
% function and geometric constaint that the camera should face the scene.
% for this we assumed that the camera is looking for the z+

%  Tests
% ------------------------------------------------------------------------
% run this script "HOW_TO_RUN.m". an example will be loaded from  Input.mat
% it contains a configuration of 3 cameras 
% camera 1 : first is a perspective reference camera
% camera 2 : perspective camera
% camera 3 : Omnidirectional camera
% and 60 2D-3D line correspandances, 

clear all
restoredefaultpath

addpath Functions
addpath Normalizing3D
addpath Solver
addpath SolverMini\

load('input.mat');
% ------------------------------------------------------------------------
% ------------------------- Important NOTE -------------------------------
% ------------------------------------------------------------------------
% since the sample synthetic data was generated at a scale where 100000 
% is equivalent to 1 meter, the results of the pose estimation is also 
% expressed at this scale the error from the ground truth(the translation)
% has to be divided with 100 000 to be expressed in meter
% this only applies to the provided synthetic data example, to have a kind of a
% metric representation of the error

dbstop if error





% ------------------------------------------------------------------------
% --------------------- Direct least squares sovler ----------------------
% ------------------------------------------------------------------------


% Direct least squares sovler with one camera returning all the solutions 
% sorted based on the line backprojection error
% ------------------------------------------------------------------------
type=1;
lineNum = 60;
[Poses1] = Cayley_LS_solver_all(input,lineNum,type);


% Test for the Direct least squares sovler with 3 cameras and 
% and 60 2D-3D lines on each camera
% ------------------------------------------------------------------------
type=1;
camNum = 3;
lineNum = [60,60,60];
[Poses2] = Cayley_LS_solver(input,camNum,lineNum,type);


%  Test for the minimal case with the direct least sqaures solver 3 2D-3D
%  lines on each one of the 3 cameras
% ------------------------------------------------------------------------
type=1;
camNum = 3;
lineNum = [3,3,3];
[Poses3] = Cayley_LS_solver(input,camNum,lineNum,type);


% ------------------------------------------------------------------------
% --------------------------- Minimal solver -----------------------------
% ------------------------------------------------------------------------


% Minimal solver with one camera and returning all the 
% solutions sorted based on the backprojection error
% ------------------------------------------------------------------------
type=1;
[Poses4] = Cayley_Mini_solver_all(input,type);


% Test for the minimal solver
% ------------------------------------------------------------------------
type=1;
camNum = 3;
[Poses5] = Cayley_Mini_solver(input,camNum,type);

% ------------------------------------------------------------------------
% -------------------------------RANSAC Test------------------------------
% ------------------------------------------------------------------------

% RANSAC test with 3 cameras  perspective as reference and a perspective
% and an omni as other cameras, with 120 2D-3D lines for each camera 60/120 are inliers and 
% 60/120 are outliers .
% ------------------------------------------------------------------------
load('input_Ransac.mat');
lineNum = [120,120,120];
type=1;
threshold = 0.01;
camNum = 3;
[Poses6,~, ~, ~, ~, ~, ~] =Cayley_RANSAC(input,lineNum,camNum,type,threshold);



