function [R_estimated,T_estimated,numberofSolutions,B1,B2,B3, pose_estimated_all, line_error_all, line_error_all_lines, imaginary] = Solver_for_Rotation(Data,algo)

%global set
%global cam
% W1: one endpoints of the 3D line
% n_c: normals of the projection planes
% Vw: unit direction vectors of the 3D lines

W1 = Data.P1_w;
n_c = Data.normals;
Vw = Data.Directions;

n1 = n_c(1,1:end);
n2 = n_c(2,1:end);
n3 = n_c(3,1:end);

v1 = Vw(1,1:end) ;
v2 = Vw(2,1:end);
v3 = Vw(3,1:end) ;

% calculation of the coefficents
[A1] = CoefA1_Caley(n1,n2,n3,v1,v2,v3);
[A2] = CoefA2_Caley(n1,n2,n3,v1,v2,v3);
[A3] = CoefA3_Caley(n1,n2,n3,v1,v2,v3);

%
b1Sum = sum(A1,2);
b2Sum = sum(A2,2);
b3Sum = sum(A3,2);



if algo==1
    
    [b1, b2, b3, imaginary] = solver_Cayley_equations(...
        b1Sum(1), b1Sum(2), b1Sum(3), b1Sum(4), b1Sum(5), b1Sum(6), b1Sum(7), b1Sum(8), b1Sum(9), b1Sum(10), ...
        b1Sum(11), b1Sum(12), b1Sum(13), b1Sum(14), b1Sum(15), b1Sum(16), b1Sum(17), b1Sum(18), b1Sum(19), b1Sum(20), ...
        b2Sum(1), b2Sum(2), b2Sum(3), b2Sum(4), b2Sum(5), b2Sum(6), b2Sum(7), b2Sum(8), b2Sum(9), b2Sum(10), ...
        b2Sum(11), b2Sum(12), b2Sum(13), b2Sum(14), b2Sum(15), b2Sum(16), b2Sum(17), b2Sum(18), b2Sum(19), b2Sum(20),...
        b3Sum(1), b3Sum(2), b3Sum(3), b3Sum(4), b3Sum(5), b3Sum(6), b3Sum(7), b3Sum(8), b3Sum(9), b3Sum(10), ...
        b3Sum(11), b3Sum(12), b3Sum(13), b3Sum(14), b3Sum(15), b3Sum(16), b3Sum(17), b3Sum(18), b3Sum(19), b3Sum(20));
elseif algo==2
    
    
    [solutions] =  cayley_solver((b1Sum),(b2Sum),(b3Sum));
    
    b1 =   solutions(1,:);
    b2 =   solutions(2,:);
    b3 =   solutions(3,:);
else
    
    disp('algorithme not defined correctly');
    return;
end



nansum1= (isnan(b1(:)));
nansum2= (isnan(b2(:)));
nansum3= (isnan(b3(:)));

numIndex = logical(nansum1) | logical(nansum2) | logical(nansum3);
numIndex = ~numIndex;

b1 = b1(numIndex);
b2 = b2(numIndex);
b3 = b3(numIndex);

numberofSolutions = size(b1,2);
idx=1;
error=inf;
R_estimated = nan;
T_estimated = nan;
B1 = nan;
B2 = nan;
B3 = nan;

line_error_all = nan(1,numberofSolutions);


R_cwInit_gt_check = nan;
T_cwInit_gt_check = nan;
for solInx=1:numberofSolutions
    
    % get back the rotation matrix
    R_selected = rot2(b1(solInx),b2(solInx),b3(solInx));
    
    % estimating the translation with SVD
    T_selected=Translation_solverLs(W1,n_c,R_selected);
    
    % Denormalization of the pose
    %Denorm_pose = [R_selected T_selected; 0 0 0 1]*  (Data.N3);
    %Denorm_pose1=Denorm_pose/norm(Denorm_pose(1:3,1:3));
    
    %
    %R_selected1 = Denorm_pose1(1:3,1:3);
    %T_selected1 = Denorm_pose1(1:3,4);
    
    
    pose_estimated = [R_selected T_selected; 0 0 0 1];
    
    
    %% VV updated %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % det(R) != 1 problem    
    if det(pose_estimated(1:3,1:3)) < 0
       warning('POSE DET != 1')
       pause
    end
    
    
    
    %% VV updated %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

    % input for the backprojection fucntion of the line on the unit sphere
    ArrayData (:,1) = Data.p1(1,:)';
    ArrayData (:,2) = Data.p1(2,:)';
    ArrayData (:,3) = Data.p1(3,:)';
    
    ArrayData (:,4) = Data.p2(1,:)';
    ArrayData (:,5) = Data.p2(2,:)';
    ArrayData (:,6) = Data.p2(3,:)';
    
    ArrayData (:,7) = Data.P1_w(1,:)';
    ArrayData (:,8) = Data.P1_w(2,:)';
    ArrayData (:,9) = Data.P1_w(3,:)';
    
    ArrayData (:,10) = Data.P2_w(1,:)';
    ArrayData (:,11) = Data.P2_w(2,:)';
    ArrayData (:,12) = Data.P2_w(3,:)';
    
    ArrayData (:,13) = Vw(1,:)';
    ArrayData (:,14) = Vw(2,:)';
    ArrayData (:,15) = Vw(3,:)';
    
    ArrayData (:,16) = n_c(1,:)';
    ArrayData (:,17) = n_c(2,:)';
    ArrayData (:,18) = n_c(3,:)';
    
    % backprojection error on the unit sphere
    [line_error] =  Back_projection_error_new_fast(pose_estimated,ArrayData(:,1),ArrayData(:,2),ArrayData(:,3),...
        ArrayData(:,4),ArrayData(:,5),ArrayData(:,6),...
        ArrayData(:,7),ArrayData(:,8),ArrayData(:,9),...
        ArrayData(:,10),ArrayData(:,11),ArrayData(:,12),...
        ArrayData(:,13),ArrayData(:,14),ArrayData(:,15),Data.cameraType);    

    
    %
             %% VV updated   ********************************
        
    line_error_all_lines{solInx} = line_error;
        
              %% VV updated ***********************************   
    line_error_all(idx) = sum(line_error);
    pose_estimated_all{idx} = pose_estimated;
    b_estimated{idx} = [b1(solInx),b2(solInx),b3(solInx)];
    
    
    
    % Note: we assume that the omni camera is looking to z+ direction 
    %g(1) parameter according to scaramuza spherical omni model is positive
    
        Zchecking1 = pose_estimated * Data.P1_w;
        Zchecking2 = pose_estimated * Data.P2_w;

        %% VV updated %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        % pose is geometrically invalid if all endpoints of a line are
        % behind the camera
        Zneg1 = Zchecking1(3,:) < 0;
        Zneg2 = Zchecking2(3,:) < 0;
        Zneg = Zneg1 & Zneg2;
        
%         if any(Zneg) test this uncomment
%             Znegative(idx) = 1;
%         else
%             Znegative(idx) = 0;
%             
%         end       
          if any(Zneg1) || any(Zneg2)
              Znegative(idx) = 1;
          else
              Znegative(idx) = 0;
          end
    
    idx = idx + 1;
    
    
end
if numberofSolutions >0
    line_error_all = line_error_all + 100000 * Znegative;
    
    [~,Idx] = min(line_error_all);
    pose =( pose_estimated_all{Idx});
    B1 = b_estimated{Idx}(1);
    B2 = b_estimated{Idx}(1);
    B3 = b_estimated{Idx}(1);
    
    R_estimated = pose(1:3,1:3);
    T_estimated = pose(1:3,4);
    
else
    pose_estimated_all = NaN;
    line_error_all = NaN;
    line_error_all_lines = NaN; 
    imaginary = NaN;
end


end


