function [pose_estimated] = Solver_for_Rotation_min_Ransac(...
    v_x,v_y,v_z,...
    n_x,n_y,n_z,...
    xs_x,xs_y,xs_z,...
    xe_x,xe_y,xe_z,...
    pw_x,pw_y,pw_z,...
    pw2_x,pw2_y,pw2_z,...
    algo,Data)



xs = [ xs_x(1,1)  xs_x(2,1)   xs_x(3,1)...
    ;  xs_y(1,1)  xs_y(2,1)   xs_y(3,1) ...
    ;  xs_z(1,1)  xs_z(2,1)   xs_z(3,1)];


xe = [ xe_x(1,1)  xe_x(2,1)   xe_x(3,1)...
    ;  xe_y(1,1)  xe_y(2,1)   xe_y(3,1) ...
    ;  xe_z(1,1)  xe_z(2,1)   xe_z(3,1)];



n_c = [ n_x(1,1)  n_x(2,1)   n_x(3,1)...
    ;  n_y(1,1)  n_y(2,1)   n_y(3,1) ...
    ;  n_z(1,1)  n_z(2,1)   n_z(3,1)];


Vw = [ v_x(1,1)  v_x(2,1)   v_x(3,1)...
    ;  v_y(1,1)  v_y(2,1)   v_y(3,1) ...
    ;  v_z(1,1)  v_z(2,1)   v_z(3,1)];

W1 = [ pw_x(1,1)  pw_x(2,1)   pw_x(3,1)...
    ;  pw_y(1,1)  pw_y(2,1)   pw_y(3,1) ...
    ;  pw_z(1,1)  pw_z(2,1)   pw_z(3,1)];


W2 = [ pw2_x(1,1)  pw2_x(2,1)   pw2_x(3,1)...
    ;  pw2_y(1,1)  pw2_y(2,1)   pw2_y(3,1) ...
    ;  pw2_z(1,1)  pw2_z(2,1)   pw2_z(3,1)];


p1_original = xs;
p2_original = xe;
W1_original = W1;
W2_original = W2;
Vw_original = Vw;
n_c_original = n_c;

n11 = n_c(1,1);
n21 = n_c(2,1);
n31 = n_c(3,1);

v11 = Vw(1,1) ;
v21 = Vw(2,1);
v31 = Vw(3,1) ;

n12 = n_c(1,2);
n22 = n_c(2,2);
n32 = n_c(3,2);

v12 = Vw(1,2) ;
v22 = Vw(2,2);
v32 = Vw(3,2) ;


n13 = n_c(1,3);
n23 = n_c(2,3);
n33 = n_c(3,3);

v13 = Vw(1,3) ;
v23 = Vw(2,3);
v33 = Vw(3,3) ;


if algo==1
    
    [A1] = Coef_Cayley_min(n11,n21,n31,v11,v21,v31);
    [A2] = Coef_Cayley_min(n12,n22,n32,v12,v22,v32);
    [A3] = Coef_Cayley_min(n13,n23,n33,v13,v23,v33);
    
    %
    b1Sum = A1;
    b2Sum = A2;
    b3Sum = A3;
    
    [b1, b2, b3] = solver_Cayley_equations_min(...
        b1Sum(1), b1Sum(2), b1Sum(3), b1Sum(4), b1Sum(5), b1Sum(6), b1Sum(7), b1Sum(8), b1Sum(9), b1Sum(10), ...
        b2Sum(1), b2Sum(2), b2Sum(3), b2Sum(4), b2Sum(5), b2Sum(6), b2Sum(7), b2Sum(8), b2Sum(9), b2Sum(10), ...
        b3Sum(1), b3Sum(2), b3Sum(3), b3Sum(4), b3Sum(5), b3Sum(6), b3Sum(7), b3Sum(8), b3Sum(9), b3Sum(10));
elseif algo==2
    
    
    [A1] = Coef_Cayley_min(n11,n21,n31,v11,v21,v31);
    [A2] = Coef_Cayley_min(n12,n22,n32,v12,v22,v32);
    [A3] = Coef_Cayley_min(n13,n23,n33,v13,v23,v33);
    
    %
    b1Sum = A1;
    b2Sum = A2;
    b3Sum = A3;
    
    [solutions] =  cayley_solver_min((b1Sum),(b2Sum),(b3Sum));
    
    b1 =   solutions(1,:);
    b2 =   solutions(2,:);
    b3 =   solutions(3,:);
    
    
else
    
    disp('algorithme not defined correctly');
    return;
end

% R = rot2(b1,b2,b3);
% Ri = rot_caley(b1,b2,b3);

b1 = b1(~isnan(b1));
b2 = b2(~isnan(b2));
b3 = b3(~isnan(b3));



numberofSolutions = size(b1,2);
idx=1;
error=inf;
R_estimated = nan;
T_estimated = nan;


line_error_all = nan(1,numberofSolutions);
R_cwInit_gt_check = nan;
T_cwInit_gt_check = nan;



for solInx=1:numberofSolutions
    
    R_selected = rot2(b1(solInx),b2(solInx),b3(solInx));
    
    
    %     R_selected =reshape(Ri,3,3);
    %     [~, ~, ~,rx ,ry ,rz] = rotAnglefromMatrix2 (R_selected1);
    %     R_selected = rotMfromAngle2 (rz, ry, rx);
    T_selected=Translation_solverLs(W1,n_c,R_selected);
    
    
    pose_estimated = [R_selected T_selected; 0 0 0 1];
    
    
    
    ArrayData (:,1) = p1_original(1,:)';
    ArrayData (:,2) = p1_original(2,:)';
    ArrayData (:,3) = p1_original(3,:)';
    
    ArrayData (:,4) = p2_original(1,:)';
    ArrayData (:,5) = p2_original(2,:)';
    ArrayData (:,6) = p2_original(3,:)';
    
    ArrayData (:,7) = W1_original(1,:)';
    ArrayData (:,8) = W1_original(2,:)';
    ArrayData (:,9) = W1_original(3,:)';
    
    ArrayData (:,10) = W2_original(1,:)';
    ArrayData (:,11) = W2_original(2,:)';
    ArrayData (:,12) = W2_original(3,:)';
    
    ArrayData (:,13) = Vw_original(1,:)';
    ArrayData (:,14) = Vw_original(2,:)';
    ArrayData (:,15) = Vw_original(3,:)';
    
    ArrayData (:,16) = n_c_original(1,:)';
    ArrayData (:,17) = n_c_original(2,:)';
    ArrayData (:,18) = n_c_original(3,:)';
    
    
    [line_error] =  Back_projection_error_new_fast(pose_estimated,ArrayData(:,1),ArrayData(:,2),ArrayData(:,3),...
        ArrayData(:,4),ArrayData(:,5),ArrayData(:,6),...
        ArrayData(:,7),ArrayData(:,8),ArrayData(:,9),...
        ArrayData(:,10),ArrayData(:,11),ArrayData(:,12),...
        ArrayData(:,13),ArrayData(:,14),ArrayData(:,15),Data.cameraType);
    
    line_error_all(idx) = min(line_error);
    pose_estimated_all{idx} = pose_estimated;
    b_estimated{idx} = [b1(solInx),b2(solInx),b3(solInx)];
    
    
    Zchecking1 = pose_estimated * Data.P1_w;
    Zchecking2 = pose_estimated * Data.P2_w;
    
    if(min(Zchecking1(3,:))<0 || min(Zchecking2(3,:))<0)
        Znegative(idx) = 1;
    else
        Znegative(idx) = 0;
        
    end
    
    idx = idx + 1;
    
    
    
    
end

if numberofSolutions>0

line_error_all = line_error_all + 100000 * Znegative;

[~,Idx] = min(line_error_all);
pose =( pose_estimated_all{Idx});
B1 = b_estimated{Idx}(1);
B2 = b_estimated{Idx}(2);
B3 = b_estimated{Idx}(3);

R_estimated = pose(1:3,1:3);
T_estimated = pose(1:3,4);

pose_estimated = pose;
else
    pose_estimated = nan;
    
end

end


