% Generated using GBSolver generator Copyright Martin Bujnak,
% Zuzana Kukelova, Tomas Pajdla CTU Prague 2008.
% 
% Please refer to the following paper, when using this code :
%     Kukelova Z., Bujnak M., Pajdla T., Automatic Generator of Minimal Problem Solvers,
%     ECCV 2008, Marseille, France, October 12-18, 2008

function [b11, b21, b31] = solver_Cayley_equations_min(d1_1, d1_2, d1_3, d1_4, d1_5, d1_6, d1_7, d1_8, d1_9, d1_10, d2_1, d2_2, d2_3, d2_4, d2_5, d2_6, d2_7, d2_8, d2_9, d2_10, d3_1, d3_2, d3_3, d3_4, d3_5, d3_6, d3_7, d3_8, d3_9, d3_10)

	% precalculate polynomial equations coefficients
	c(1) = d1_7;
	c(2) = d1_6;
	c(3) = d1_5;
	c(4) = d1_4;
	c(5) = d1_3;
	c(6) = d1_2;
	c(7) = d1_10;
	c(8) = d1_9;
	c(9) = d1_8;
	c(10) = d1_1;
	c(11) = d2_7;
	c(12) = d2_6;
	c(13) = d2_5;
	c(14) = d2_4;
	c(15) = d2_3;
	c(16) = d2_2;
	c(17) = d2_10;
	c(18) = d2_9;
	c(19) = d2_8;
	c(20) = d2_1;
	c(21) = d3_7;
	c(22) = d3_6;
	c(23) = d3_5;
	c(24) = d3_4;
	c(25) = d3_3;
	c(26) = d3_2;
	c(27) = d3_10;
	c(28) = d3_9;
	c(29) = d3_8;
	c(30) = d3_1;

	M1 = zeros(3, 10);
	M1(16) = c(1);
	M1(7) = c(2);
	M1(1) = c(3);
	M1(13) = c(4);
	M1(10) = c(5);
	M1(4) = c(6);
	M1(25) = c(7);
	M1(22) = c(8);
	M1(19) = c(9);
	M1(28) = c(10);
	M1(17) = c(11);
	M1(8) = c(12);
	M1(2) = c(13);
	M1(14) = c(14);
	M1(11) = c(15);
	M1(5) = c(16);
	M1(26) = c(17);
	M1(23) = c(18);
	M1(20) = c(19);
	M1(29) = c(20);
	M1(18) = c(21);
	M1(9) = c(22);
	M1(3) = c(23);
	M1(15) = c(24);
	M1(12) = c(25);
	M1(6) = c(26);
	M1(27) = c(27);
	M1(24) = c(28);
	M1(21) = c(29);
	M1(30) = c(30);

% 	M1 = rref(M1);
	M1 = frref(M1);

	M2 = zeros(12, 20);
	M2(10:12, [11 12 13 14 15 16 17 18 19 20]) = M1(1:3, :);
	M2([1 14 51]) = M1(1);
	M2([16 29 66]) = M1(5);
	M2([31 44 81]) = M1(9);
	M2([49 62 87]) = M1(10);
	M2([52 65 90]) = M1(11);
	M2([55 68 93]) = M1(12);
	M2([61 74 99]) = M1(13);
	M2([64 77 102]) = M1(14);
	M2([67 80 105]) = M1(15);
	M2([85 98 111]) = M1(16);
	M2([88 101 114]) = M1(17);
	M2([91 104 117]) = M1(18);
	M2([121 134 159]) = M1(19);
	M2([124 137 162]) = M1(20);
	M2([127 140 165]) = M1(21);
	M2([133 146 171]) = M1(22);
	M2([136 149 174]) = M1(23);
	M2([139 152 177]) = M1(24);
	M2([157 170 183]) = M1(25);
	M2([160 173 186]) = M1(26);
	M2([163 176 189]) = M1(27);
	M2([193 206 219]) = M1(28);
	M2([196 209 222]) = M1(29);
	M2([199 212 225]) = M1(30);
% 	M2 = rref(M2);
	M2 = frref(M2);

	M = zeros(20, 28);
	M(11:20, [11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28]) = M2([1 2 3 5 6 7 8 9 10 11], [1 2 3 5 6 7 8 9 10 11 12 14 15 16 17 18 19 20]);
	M([21 42 83]) = M2(130);
	M([4 45 66 107]) = M2(143);
	M([8 69 130]) = M2(156);
	M([81 102 143]) = M2(166);
	M([44 85 106 147]) = M2(167);
	M([28 89 150]) = M2(168);
	M([101 122 163]) = M2(178);
	M([64 105 126 167]) = M2(179);
	M([48 109 170]) = M2(180);
	M([141 162 183]) = M2(190);
	M([104 145 166 187]) = M2(191);
	M([88 149 190]) = M2(192);
	M([261 282 323]) = M2(202);
	M([224 265 286 327]) = M2(203);
	M([208 269 330]) = M2(204);
	M([281 302 343]) = M2(214);
	M([244 285 306 347]) = M2(215);
	M([228 289 350]) = M2(216);
	M([321 342 363]) = M2(226);
	M([284 325 346 367]) = M2(227);
	M([268 329 370]) = M2(228);
	M([421 442 463]) = M2(238);
	M([404 425 446 467]) = M2(239);
	M([388 429 470]) = M2(240);
% 	M = rref(M);
	M = frref(M);

	A = zeros(8);
	amcols = [28 27 26 25 24 23 22 19];
	A(1, 4) = 1;
	A(2, 7) = 1;
	A(3, :) = -M(20, amcols);
	A(4, :) = -M(19, amcols);
	A(5, :) = -M(17, amcols);
	A(6, :) = -M(15, amcols);
	A(7, :) = -M(14, amcols);
	A(8, :) = -M(8, amcols);

	[V D] = eig(A);
	sol =  V([4, 3, 2],:)./(ones(3, 1)*V(1,:));

% 	if (find(isnan(sol(:))) > 0)
% 		
% 		b11 = zeros(1, 0);
% 		b21 = zeros(1, 0);
% 		b31 = zeros(1, 0);
% 	else
% 		
% 		I = find(not(imag( sol(1,:) )));
% 		b11 = sol(1,I);
% 		b21 = sol(2,I);
% 		b31 = sol(3,I);
% 	end


    %% VV updated %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
	if (find(isnan(sol(:))) > 0)
		
		b11 = zeros(1, 0);
		b21 = zeros(1, 0);
		b31 = zeros(1, 0);
        imaginary = zeros(1, 0);
	else
		
% 		I = find(not(imag( sol(1,:) )));
% 
% 		b11 = sol(1,I);
% 		b21 = sol(2,I);
% 		b31 = sol(3,I);

        % Keep all solutions, not only real ones                
        I = true(1,size(sol,2));
        b11 = real(sol(1,I));
        b21 = real(sol(2,I));
        b31 = real(sol(3,I));
        imaginary = [];
        imaginary = imag(sol(:,I));

	end

end
